/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Item;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndDeleteItemTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Item Test");
        this.setDescription("Creates a few items, checks the newly created itens and their parent and finally deletes the created item.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Items are not supported by CMIS 1.0. Test skipped!"));
            return;
        }
        if (this.hasItems(session)) {
            int numOfItems = 20;
            Folder testFolder = this.createTestFolder(session);
            try {
                CmisTestResultImpl f;
                HashMap<String, Item> items = new HashMap<String, Item>();
                for (int i = 0; i < numOfItems; ++i) {
                    Item newItem = this.createItem(session, testFolder, "item" + i);
                    items.put(newItem.getId(), newItem);
                }
                ItemIterable children = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC);
                ArrayList<String> childrenIds = new ArrayList<String>();
                for (CmisObject child : children) {
                    if (child == null) continue;
                    childrenIds.add(child.getId());
                    Item item = (Item)items.get(child.getId());
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Item and test folder child don't match! Id: " + child.getId());
                    this.addResult(this.assertShallowEquals((CmisObject)item, child, null, f));
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "Number of created items does not match the number of existing items!");
                this.addResult(this.assertEquals(numOfItems, childrenIds.size(), null, (CmisTestResult)f));
                for (Item item : items.values()) {
                    if (childrenIds.contains(item.getId())) continue;
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Created item not found in test folder children! Id: " + item.getId()));
                }
                for (Item item : items.values()) {
                    item.delete(true);
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Item should not exist anymore but it is still there! Id: " + item.getId());
                    this.addResult(this.assertIsFalse(this.exists((CmisObject)item), null, f));
                }
            }
            finally {
                this.deleteTestFolder();
            }
            this.addResult(this.createInfoResult("Tested the creation and deletion of " + numOfItems + " items."));
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Items not supported. Test skipped!"));
        }
    }
}

