/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.ArrayList;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySmokeTest
extends AbstractQueryTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query Smoke Test");
        this.setDescription("Performs a simple query and checks if the format of the results is correct. It does not check if the results are complete!");
    }

    @Override
    public void run(Session session) {
        if (this.supportsQuery(session)) {
            String testType = "cmis:document";
            String statement = "SELECT * FROM " + testType;
            this.addResult(this.createInfoResult("Query: " + statement));
            ObjectType type = session.getTypeDefinition(testType);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Test type definition '" + testType + "'not found!");
            this.addResult(this.assertNotNull(type, null, f));
            if (type == null) {
                return;
            }
            PropertyDefinition objectIdPropDef = (PropertyDefinition)type.getPropertyDefinitions().get("cmis:objectId");
            f = this.createResult(CmisTestResultStatus.FAILURE, "Object Id property definition does not exist!");
            this.addResult(this.assertNotNull(objectIdPropDef, null, f));
            String objectIdQueryName = null;
            if (objectIdPropDef != null) {
                objectIdQueryName = objectIdPropDef.getQueryName();
            }
            int pageSize = 100;
            ItemIterable resultSet = session.query(statement, false);
            if (resultSet == null) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Query result set is null! (OpenCMIS issue???)"));
            } else {
                int i = 0;
                ItemIterable queryIterable = resultSet.getPage(pageSize);
                for (QueryResult qr : queryIterable) {
                    if (qr == null) {
                        this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Query result is null! (OpenCMIS issue???)"));
                    } else {
                        this.addResult(this.checkQueryResult(session, qr, type, "Query result: " + i));
                        if (objectIdQueryName != null) {
                            String objectId = (String)qr.getPropertyByQueryName(objectIdQueryName).getFirstValue();
                            try {
                                CmisObject object = session.getObject(objectId, SELECT_ALL_NO_CACHE_OC);
                                this.addResult(this.checkObject(session, object, this.getAllProperties(object), "Query hit check. Id: " + objectId));
                            }
                            catch (CmisObjectNotFoundException e) {
                                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Query hit references an object that doesn't exist. Id: " + objectId, e, false));
                            }
                        }
                    }
                    ++i;
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "More query results (" + i + ") than expected (page size = " + pageSize + ")!");
                this.addResult(this.assertIsFalse(i > pageSize, null, f));
                if (queryIterable.getTotalNumItems() == -1L) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Repository did not return numItems."));
                }
                this.addResult(this.createInfoResult(i + " query results for \"" + statement + "\" (page size = " + pageSize + ")"));
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Query not supported. Test Skipped!"));
        }
    }

    protected CmisTestResult checkQueryResult(Session session, QueryResult qr, ObjectType type, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (qr.getProperties().isEmpty()) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Query result is empty!"));
        } else {
            for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                if (propDef.getQueryName() == null) continue;
                PropertyData pd = qr.getPropertyByQueryName(propDef.getQueryName());
                if (pd == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Query property not in result set: " + propDef.getQueryName()));
                    continue;
                }
                if (!"cmis:objectId".equals(propDef.getId()) && !"cmis:objectTypeId".equals(propDef.getId()) && !"cmis:baseTypeId".equals(propDef.getId())) continue;
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Query property must not be empty: " + propDef.getQueryName());
                this.addResult(results, this.assertStringNotEmpty((String)pd.getFirstValue(), null, f));
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }
}

