/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.versioning;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionDeleteTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Versioning Delete Test");
        this.setDescription("Creates a document, adds three versions and deletes the current version until the document is gone.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Folder testFolder = this.createTestFolder(session);
            Document doc = this.createDocument(session, testFolder, "versiondeletetest.txt", "v1");
            DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
            if (!docType.isVersionable().booleanValue()) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Test type is not versionable. Test skipped!"));
                doc.delete(true);
                return;
            }
            Document doc2 = this.createVersion(session, doc, "v2", 2);
            Document doc3 = this.createVersion(session, doc2, "v3", 3);
            Document doc4 = this.createVersion(session, doc3, "v4", 4);
            this.deleteVersion(doc4, doc3, 4);
            this.deleteVersion(doc3, doc2, 3);
            this.deleteVersion(doc2, doc, 2);
            this.deleteVersion(doc, null, 1);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private Document createVersion(Session session, Document doc, String content, int version) {
        byte[] contentBytes;
        ObjectId pwcId = doc.checkOut();
        Document pwc = (Document)session.getObject(pwcId, SELECT_ALL_NO_CACHE_OC);
        this.addResult(this.checkObject(session, (CmisObject)pwc, this.getAllProperties((CmisObject)pwc), "PWC " + version + " compliance"));
        try {
            contentBytes = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            contentBytes = content.getBytes();
        }
        ContentStreamImpl contentStream = new ContentStreamImpl(doc.getName(), BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
        ObjectId newVersionId = pwc.checkIn(true, null, (ContentStream)contentStream, "test version " + version);
        IOUtils.closeQuietly((ContentStream)contentStream);
        Document newVersion = (Document)session.getObject(newVersionId, SELECT_ALL_NO_CACHE_OC);
        this.addResult(this.checkObject(session, (CmisObject)newVersion, this.getAllProperties((CmisObject)newVersion), "Version " + version + " compliance"));
        List versions = doc.getAllVersions();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Version series should have " + version + " versions but has " + versions.size() + "!");
        this.addResult(this.assertEquals(version, versions.size(), null, (CmisTestResult)f));
        if (versions.size() > 0) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created version " + version + " is not the latest version!");
            this.addResult(this.assertEquals(newVersion.getId(), ((Document)versions.get(0)).getId(), null, (CmisTestResult)f));
            if (versions.size() > 1) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "The previous version of version " + version + " is not the document it has been created from!");
                this.addResult(this.assertEquals(doc.getId(), ((Document)versions.get(1)).getId(), null, (CmisTestResult)f));
            }
        }
        return newVersion;
    }

    private void deleteVersion(Document versionDoc, Document previousDoc, int version) {
        List versionsBefore = versionDoc.getAllVersions();
        versionDoc.delete(false);
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Deleted version " + version + " still exists!");
        this.addResult(this.assertIsFalse(this.exists((CmisObject)versionDoc), null, f));
        if (previousDoc != null) {
            List versionsAfter = previousDoc.getAllVersions();
            f = this.createResult(CmisTestResultStatus.FAILURE, "After version " + version + " has been deleted, the version history should consist of " + (versionsBefore.size() - 1) + "  documents but is has " + versionsAfter.size() + " !");
            this.addResult(this.assertEquals(versionsBefore.size() - 1, versionsAfter.size(), null, (CmisTestResult)f));
        }
    }
}

