/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.basics;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.ExtensionFeature;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryInfoTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Repository Info Test");
        this.setDescription("Gets and checks the repository info.");
    }

    @Override
    public void run(Session session) {
        RepositoryInfo ri = this.getRepositoryInfo(session);
        CmisTestResultImpl success = this.createResult(CmisTestResultStatus.OK, "Repository id: " + ri.getId());
        CmisTestResultImpl failure = this.createResult(CmisTestResultStatus.FAILURE, "Repository id is not set!", true);
        this.addResult(this.assertStringNotEmpty(ri.getId(), success, failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Repository name is not set!");
        this.addResult(this.assertNotNull(ri.getName(), null, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Repository name: " + ri.getName());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Repository name is empty!");
        this.addResult(this.assertStringNotEmpty(ri.getName(), success, failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Repository description is not set!");
        this.addResult(this.assertNotNull(ri.getDescription(), null, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Repository description: " + ri.getDescription());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Repository description is empty!");
        this.addResult(this.assertStringNotEmpty(ri.getDescription(), success, failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Vendor name is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getVendorName(), null, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Vendor name: " + ri.getVendorName());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Vendor name is empty!");
        this.addResult(this.assertStringNotEmpty(ri.getVendorName(), success, failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Product name is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getProductName(), null, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Product name: " + ri.getProductName());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Product name is empty!");
        this.addResult(this.assertStringNotEmpty(ri.getProductName(), success, failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Product version is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getProductVersion(), null, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Product version: " + ri.getProductVersion());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Product version is empty!");
        this.addResult(this.assertStringNotEmpty(ri.getProductVersion(), success, failure));
        success = this.createResult(CmisTestResultStatus.OK, "CMIS Version Supported: " + ri.getCmisVersionSupported());
        failure = this.createResult(CmisTestResultStatus.FAILURE, "CMIS Version Supported is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getCmisVersionSupported(), success, failure));
        if (!"1.0".equals(ri.getCmisVersionSupported()) && !"1.1".equals(ri.getCmisVersionSupported())) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "CMIS Version Supported is neither '1.0' nor '1.1'!"));
        }
        success = this.createResult(CmisTestResultStatus.OK, "Root folder id: " + ri.getRootFolderId());
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder id is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getRootFolderId(), success, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Thin client URI: " + ri.getThinClientUri());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Thin client URI is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getThinClientUri(), success, failure));
        if (ri.getThinClientUri() != null && ri.getThinClientUri().length() > 0) {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(ri.getThinClientUri()).openConnection();
                conn.connect();
                int responseCode = conn.getResponseCode();
                failure = this.createResult(CmisTestResultStatus.WARNING, "Unable to connect to thin client '" + ri.getThinClientUri() + "'. HTTP status code: " + responseCode);
                this.addResult(this.assertIsTrue(responseCode >= 200 && responseCode < 400, null, failure));
                conn.disconnect();
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Unable to connect to thin client '" + ri.getThinClientUri() + "': " + e.getMessage(), e, false));
            }
        }
        success = this.createResult(CmisTestResultStatus.OK, "Principal Id anonymous: " + ri.getPrincipalIdAnonymous());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Principal Id anonymous is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getPrincipalIdAnonymous(), success, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Principal Id anyone: " + ri.getPrincipalIdAnyone());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Principal Id anyone is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getPrincipalIdAnyone(), success, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Latest change log token: " + ri.getLatestChangeLogToken());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Latest change log token is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getLatestChangeLogToken(), success, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Changes Incomplete: " + ri.getChangesIncomplete());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Changes Incomplete is not set!");
        this.addResult(this.assertNotNull(ri.getChangesIncomplete(), success, failure));
        success = this.createResult(CmisTestResultStatus.OK, "Changes on type: " + ri.getChangesOnType());
        failure = this.createResult(CmisTestResultStatus.WARNING, "Changes on type is not set!");
        this.addResult(this.assertNotNull(ri.getChangesOnType(), success, failure));
        if (ri.getChangesOnType() != null) {
            failure = this.createResult(CmisTestResultStatus.WARNING, "Changes on type has more than 4 entries!");
            this.addResult(this.assertIsTrue(ri.getChangesOnType().size() < 5, null, failure));
        }
        if (ri.getCmisVersion() != CmisVersion.CMIS_1_0) {
            success = this.createResult(CmisTestResultStatus.OK, "Repository features exposed.");
            failure = this.createResult(CmisTestResultStatus.OK, "No repository features exposed.");
            this.addResult(this.assertNotNull(ri.getExtensionFeatures(), success, failure));
            if (ri.getExtensionFeatures() != null) {
                for (ExtensionFeature feature : ri.getExtensionFeatures()) {
                    failure = this.createResult(CmisTestResultStatus.FAILURE, "At least one repository features has no id!");
                    this.addResult(this.assertStringNotEmpty(feature.getId(), null, failure));
                }
            }
        }
        if (ri.getCapabilities() == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Capabilities are not set!"));
        } else {
            RepositoryCapabilities cap = ri.getCapabilities();
            success = this.createResult(CmisTestResultStatus.OK, "ACL capability: " + cap.getAclCapability());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "ACL capability is not set!");
            this.addResult(this.assertNotNull(cap.getAclCapability(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Changes capability: " + cap.getChangesCapability());
            failure = this.createResult(CmisTestResultStatus.WARNING, "Changes capability is not set!");
            this.addResult(this.assertNotNull(cap.getChangesCapability(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Content stream updates capability: " + cap.getContentStreamUpdatesCapability());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Content stream updates is not set!");
            this.addResult(this.assertNotNull(cap.getContentStreamUpdatesCapability(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Get descendants capability: " + cap.isGetDescendantsSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Get descendants capability is not set!");
            this.addResult(this.assertNotNull(cap.isGetDescendantsSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Get folder tree capability: " + cap.isGetFolderTreeSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Get folder tree capability is not set!");
            this.addResult(this.assertNotNull(cap.isGetFolderTreeSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Multifiling capability: " + cap.isMultifilingSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Multifiling capability is not set!");
            this.addResult(this.assertNotNull(cap.isMultifilingSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Unfiling capability: " + cap.isUnfilingSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Unfiling capability is not set!");
            this.addResult(this.assertNotNull(cap.isUnfilingSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Version specific filing capability: " + cap.isVersionSpecificFilingSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Version specific filing capability is not set!");
            this.addResult(this.assertNotNull(cap.isVersionSpecificFilingSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Query capability: " + cap.getQueryCapability());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Query capability is not set!");
            this.addResult(this.assertNotNull(cap.getQueryCapability(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "JOIN capability: " + cap.getJoinCapability());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "JOIN capability is not set!");
            this.addResult(this.assertNotNull(cap.getJoinCapability(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "All versions searchable capability: " + cap.isAllVersionsSearchableSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "All versions searchable capability is not set!");
            this.addResult(this.assertNotNull(cap.isAllVersionsSearchableSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "PWC searchable capability: " + cap.isPwcSearchableSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "PWC searchable capability is not set!");
            this.addResult(this.assertNotNull(cap.isPwcSearchableSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "PWC updatable capability: " + cap.isPwcUpdatableSupported());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "PWC updatable capability is not set!");
            this.addResult(this.assertNotNull(cap.isPwcUpdatableSupported(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Renditions capability: " + cap.getRenditionsCapability());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Renditions capability is not set!");
            this.addResult(this.assertNotNull(cap.getRenditionsCapability(), success, failure));
            if (ri.getCmisVersion() != CmisVersion.CMIS_1_0) {
                success = this.createResult(CmisTestResultStatus.OK, "'New type settable attributes' flags are set.");
                failure = this.createResult(CmisTestResultStatus.WARNING, "'New type settable attributes' flags are not set!");
                this.addResult(this.assertNotNull(cap.getNewTypeSettableAttributes(), success, failure));
                success = this.createResult(CmisTestResultStatus.OK, "'Creatable property types' flags are set.");
                failure = this.createResult(CmisTestResultStatus.WARNING, "'Creatable property types' flags are not set!");
                this.addResult(this.assertNotNull(cap.getCreatablePropertyTypes(), success, failure));
            }
        }
        if (ri.getAclCapabilities() == null) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "ACL capabilities are not set!"));
        } else {
            AclCapabilities aclCap = ri.getAclCapabilities();
            success = this.createResult(CmisTestResultStatus.OK, "Supported permissions: " + aclCap.getSupportedPermissions());
            failure = this.createResult(CmisTestResultStatus.WARNING, "Supported permissions are not set!");
            this.addResult(this.assertNotNull(aclCap.getSupportedPermissions(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "ACL propagation: " + aclCap.getAclPropagation());
            failure = this.createResult(CmisTestResultStatus.WARNING, "ACL propagation is not set!");
            this.addResult(this.assertNotNull(aclCap.getAclPropagation(), success, failure));
            success = this.createResult(CmisTestResultStatus.OK, "Permissions: " + (aclCap.getPermissions() == null ? "?" : Integer.valueOf(aclCap.getPermissions().size())));
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Permissions are not set!");
            this.addResult(this.assertNotNull(aclCap.getPermissions(), success, failure));
            if (aclCap.getPermissions() != null) {
                int i = 0;
                for (PermissionDefinition permDef : aclCap.getPermissions()) {
                    failure = this.createResult(CmisTestResultStatus.FAILURE, "Permission #" + i + " is not set!");
                    this.addResult(this.assertNotNull(permDef, null, failure));
                    if (permDef != null) {
                        failure = this.createResult(CmisTestResultStatus.FAILURE, "Id of permission #" + i + " is not set!");
                        this.addResult(this.assertStringNotEmpty(permDef.getId(), null, failure));
                    }
                    ++i;
                }
            }
            success = this.createResult(CmisTestResultStatus.OK, "Permission mapping: " + (aclCap.getPermissionMapping() == null ? "?" : Integer.valueOf(aclCap.getPermissionMapping().size())));
            failure = this.createResult(CmisTestResultStatus.WARNING, "Permission mapping is not set!");
            this.addResult(this.assertNotNull(aclCap.getPermissionMapping(), success, failure));
        }
    }
}

