/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSmokeTest
extends AbstractSessionTest {
    private static final String DOC_NAME1 = "updatetest1.txt";
    private static final String DOC_NAME2 = "updatetest2.txt";
    private static final String FOLDER_NAME1 = "updatetest1";
    private static final String FOLDER_NAME2 = "updatetest2";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Update Smoke Test");
        this.setDescription("Creates a document, updates its name and finally deletes it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Folder testFolder = this.createTestFolder(session);
            this.updateDocument(session, testFolder);
            this.updateFolder(session, testFolder);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private void updateDocument(Session session, Folder testFolder) {
        Document doc1;
        Document workDoc = doc1 = this.createDocument(session, testFolder, DOC_NAME1, "rename me!");
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Document name doesn't match the given name!");
        this.addResult(this.assertEquals(DOC_NAME1, doc1.getName(), null, (CmisTestResult)f));
        boolean checkedout = false;
        DocumentTypeDefinition type = (DocumentTypeDefinition)doc1.getType();
        PropertyDefinition namePropDef = (PropertyDefinition)type.getPropertyDefinitions().get("cmis:name");
        if (namePropDef.getUpdatability() == Updatability.WHENCHECKEDOUT || !doc1.getAllowableActions().getAllowableActions().contains(Action.CAN_UPDATE_PROPERTIES) && Boolean.TRUE.equals(type.isVersionable())) {
            workDoc = (Document)session.getObject(doc1.checkOut(), SELECT_ALL_NO_CACHE_OC);
            checkedout = true;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", DOC_NAME2);
        ObjectId newId = workDoc.updateProperties(properties, false);
        Document doc2 = (Document)session.getObject(newId, SELECT_ALL_NO_CACHE_OC);
        this.addResult(this.checkObject(session, (CmisObject)doc2, this.getAllProperties((CmisObject)doc2), "Updated document compliance"));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Document name doesn't match updated value!");
        this.addResult(this.assertEquals(DOC_NAME2, doc2.getName(), null, (CmisTestResult)f));
        if (!workDoc.getId().equals(doc2.getId())) {
            this.deleteObject((CmisObject)doc2);
        }
        if (checkedout) {
            workDoc.cancelCheckOut();
        }
        if (!doc1.getId().equals(doc2.getId()) && this.exists((CmisObject)doc1)) {
            this.deleteObject((CmisObject)doc1);
        }
    }

    private void updateFolder(Session session, Folder testFolder) {
        Folder folder = this.createFolder(session, testFolder, FOLDER_NAME1);
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Folder name doesn't match the given name!");
        this.addResult(this.assertEquals(FOLDER_NAME1, folder.getName(), null, (CmisTestResult)f));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", FOLDER_NAME2);
        ObjectId newId = folder.updateProperties(properties, false);
        f = this.createResult(CmisTestResultStatus.WARNING, "Folder id changed after name update! The folder id should never change!");
        this.addResult(this.assertEquals(folder.getId(), newId.getId(), null, (CmisTestResult)f));
        folder.refresh();
        f = this.createResult(CmisTestResultStatus.FAILURE, "Folder name doesn't match updated value!");
        this.addResult(this.assertEquals(FOLDER_NAME2, folder.getName(), null, (CmisTestResult)f));
        this.deleteObject((CmisObject)folder);
    }
}

