/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.versioning;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningSmokeTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Versioning Smoke Test");
        this.setDescription("Creates a document, checks it out, cancels the check out, checks it out again and finally checks it in.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Folder testFolder = this.createTestFolder(session);
            Document doc = this.createDocument(session, testFolder, "versioningtest.txt", "versioning");
            DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
            if (!docType.isVersionable().booleanValue()) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Test type is not versionable. Test skipped!"));
                doc.delete(true);
                return;
            }
            String[] propertiesToCheck = new String[doc.getType().getPropertyDefinitions().size()];
            int i = 0;
            for (String propId : doc.getType().getPropertyDefinitions().keySet()) {
                propertiesToCheck[i++] = propId;
            }
            ObjectId pwcId = doc.checkOut();
            Document pwc = (Document)session.getObject(pwcId, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)pwc, this.getAllProperties((CmisObject)pwc), "PWC spec compliance - test 1"));
            this.checkCheckedOut(pwc);
            this.addResult(this.checkVersionSeries(session, pwc.getAllVersions(SELECT_ALL_NO_CACHE_OC), propertiesToCheck, "Test version series after check out"));
            pwc.cancelCheckOut();
            doc.refresh();
            this.checkCheckedIn(doc);
            pwcId = doc.checkOut();
            pwc = (Document)session.getObject(pwcId, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)pwc, this.getAllProperties((CmisObject)pwc), "PWC spec compliance - test 2"));
            this.checkCheckedOut(pwc);
            ObjectId newVersionId = pwc.checkIn(true, null, null, "Test Version 2");
            Document newVersion = (Document)session.getObject(newVersionId, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)newVersion, this.getAllProperties((CmisObject)newVersion), "New version compliance"));
            this.checkCheckedIn(newVersion);
            List versions = newVersion.getAllVersions(SELECT_ALL_NO_CACHE_OC);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Version series should have 2 versions but has " + versions.size() + "!");
            this.addResult(this.assertEquals(2, versions.size(), null, (CmisTestResult)f));
            if (versions.size() > 0) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version history order is incorrect! The first version should be the new version.");
                this.addResult(this.assertEquals(newVersion.getId(), ((Document)versions.get(0)).getId(), null, (CmisTestResult)f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "The new version should be the latest version, but cmis:isLatestVersion is not TRUE.");
                this.addResult(this.assertEquals(true, ((Document)versions.get(0)).isLatestVersion(), null, (CmisTestResult)f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "The new version should be the latest major version, but cmis:isLatestMajorVersion is not TRUE.");
                this.addResult(this.assertEquals(true, ((Document)versions.get(0)).isLatestMajorVersion(), null, (CmisTestResult)f));
            }
            if (versions.size() > 1) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version history order is incorrect! The second version should be the origin document.");
                this.addResult(this.assertEquals(doc.getId(), ((Document)versions.get(1)).getId(), null, (CmisTestResult)f));
            }
            this.addResult(this.checkVersionSeries(session, versions, propertiesToCheck, "Test version series after check in"));
            this.deleteObject((CmisObject)doc);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private void checkCheckedOut(Document pwc) {
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Version series has a PWC but cmis:isVersionSeriesCheckedOut is not TRUE!");
        this.addResult(this.assertIsTrue(pwc.isVersionSeriesCheckedOut(), null, f));
        if (pwc.getVersionSeriesCheckedOutId() == null) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "cmis:versionSeriesCheckedOutId is not set!"));
        } else {
            f = this.createResult(CmisTestResultStatus.FAILURE, "PWC id and cmis:versionSeriesCheckedOutId don't match!");
            this.addResult(this.assertEquals(pwc.getId(), pwc.getVersionSeriesCheckedOutId(), null, (CmisTestResult)f));
        }
        f = this.createResult(CmisTestResultStatus.WARNING, "PWC does not have a value for cmis:versionSeriesCheckedOutBy!");
        this.addResult(this.assertStringNotEmpty(pwc.getVersionSeriesCheckedOutBy(), null, f));
    }

    private void checkCheckedIn(Document doc) {
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Version series is not checked out but cmis:isVersionSeriesCheckedOut is not FALSE!");
        this.addResult(this.assertIsFalse(doc.isVersionSeriesCheckedOut(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Version series is not checked out but cmis:versionSeriesCheckedOutId has a value!");
        this.addResult(this.assertNull(doc.getVersionSeriesCheckedOutId(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Version series is not checked out but cmis:versionSeriesCheckedOutBy has a value!");
        this.addResult(this.assertNull(doc.getVersionSeriesCheckedOutBy(), null, f));
    }

    private CmisTestResult checkVersionSeries(Session session, List<Document> versions, String[] properties, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        int countLatest = 0;
        int countLatestMajor = 0;
        String latestId = null;
        for (Document version : versions) {
            this.addResult(results, this.checkObject(session, (CmisObject)version, properties, "Version object check: " + version.getId()));
            if (Boolean.TRUE.equals(version.isLatestVersion())) {
                ++countLatest;
                latestId = version.getId();
            }
            if (!Boolean.TRUE.equals(version.isLatestMajorVersion())) continue;
            ++countLatestMajor;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "The version series must have exactly one latest version, but it has " + countLatest + "!");
        this.addResult(results, this.assertEquals(1, countLatest, null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "The version series must have zero or one latest major version, but it has " + countLatestMajor + "!");
        this.addResult(results, this.assertIsTrue(countLatestMajor < 2, null, f));
        if (countLatest == 1) {
            Document latestVersion = versions.get(0).getObjectOfLatestVersion(false, SELECT_ALL_NO_CACHE_OC);
            this.addResult(results, this.checkObject(session, (CmisObject)latestVersion, properties, "Latest version object check: " + latestVersion.getId()));
            f = this.createResult(CmisTestResultStatus.FAILURE, "The version that is flagged as latest version is not returned by getObjectOfLatestVersion()!");
            this.addResult(results, this.assertEquals(latestId, latestVersion.getId(), null, (CmisTestResult)f));
            Document latestVersion2 = session.getLatestDocumentVersion(versions.get(versions.size() - 1).getId(), SELECT_ALL_NO_CACHE_OC);
            this.addResult(results, this.checkObject(session, (CmisObject)latestVersion2, properties, "Latest version object check (2): " + latestVersion2.getId()));
            f = this.createResult(CmisTestResultStatus.FAILURE, "The version that is flagged as latest version is not returned by getObjectOfLatestVersion()!");
            this.addResult(results, this.assertEquals(latestId, latestVersion2.getId(), null, (CmisTestResult)f));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }
}

