/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractCmisTestGroup;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.impl.FatalTestException;
import org.apache.chemistry.opencmis.tck.impl.JUnitHelper;
import org.junit.Test;

public abstract class AbstractCmisTest
implements CmisTest {
    private Map<String, String> parameters;
    private AbstractCmisTestGroup group;
    private String name;
    private String description;
    private boolean isEnabled = true;
    private List<CmisTestResult> results;
    private long time;

    @Override
    public void init(Map<String, String> parameters) {
        this.parameters = parameters;
        this.results = new ArrayList<CmisTestResult>();
    }

    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGroup(AbstractCmisTestGroup group) {
        this.group = group;
    }

    public AbstractCmisTestGroup getGroup() {
        return this.group;
    }

    @Override
    public abstract void run() throws Exception;

    @Test
    public void junit() throws Exception {
        JUnitHelper.run(this);
    }

    @Override
    public List<CmisTestResult> getResults() {
        return this.results;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public CmisTestResultImpl createResult(CmisTestResultStatus status, String message, Throwable exception, boolean isFatal) {
        return new CmisTestResultImpl(this.group.getName(), this.name, message, status, exception, isFatal);
    }

    public CmisTestResultImpl createResult(CmisTestResultStatus status, String message, boolean isFatal) {
        return new CmisTestResultImpl(this.group.getName(), this.name, message, status, null, isFatal);
    }

    public CmisTestResultImpl createResult(CmisTestResultStatus status, String message) {
        return new CmisTestResultImpl(this.group.getName(), this.name, message, status, null, false);
    }

    public CmisTestResultImpl createInfoResult(String message) {
        return new CmisTestResultImpl(this.group.getName(), this.name, message, CmisTestResultStatus.INFO, null, false);
    }

    public void addResult(CmisTestResult result) {
        if (result != null) {
            if (result instanceof CmisTestResultImpl) {
                ((CmisTestResultImpl)result).setStackTrace(this.getStackTrace());
            }
            this.results.add(result);
            if (result.isFatal()) {
                throw new FatalTestException(result.getMessage());
            }
        }
    }

    protected StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] shortStackTrace = new StackTraceElement[]{};
        if (stackTrace.length > 3) {
            shortStackTrace = new StackTraceElement[stackTrace.length - 3];
            System.arraycopy(stackTrace, 3, shortStackTrace, 0, stackTrace.length - 3);
        }
        return shortStackTrace;
    }

    protected CmisTestResult addResultChild(CmisTestResult result, CmisTestResult child) {
        if (result == null) {
            return null;
        }
        result.getChildren().add(child);
        return result;
    }

    protected String formatValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Calendar) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return sdf.format(((Calendar)o).getTime());
        }
        return o.toString();
    }

    protected boolean isEqual(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return true;
        }
        return expected != null && expected.equals(actual);
    }

    protected CmisTestResult assertIsTrue(Boolean test, CmisTestResult success, CmisTestResult failure) {
        if (test != null && test.booleanValue()) {
            return success;
        }
        if (test == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Null!"));
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "False!"));
    }

    protected CmisTestResult assertIsFalse(Boolean test, CmisTestResult success, CmisTestResult failure) {
        if (test != null && !test.booleanValue()) {
            return success;
        }
        if (test == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Null!"));
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "True!"));
    }

    protected CmisTestResult assertNull(Object object, CmisTestResult success, CmisTestResult failure) {
        if (object == null) {
            return success;
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Object is not null!"));
    }

    protected CmisTestResult assertNotNull(Object object, CmisTestResult success, CmisTestResult failure) {
        if (object != null) {
            return success;
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Object is null!"));
    }

    protected CmisTestResult assertStringNullOrEmpty(String str, CmisTestResult success, CmisTestResult failure) {
        if (str == null || str.length() == 0) {
            return success;
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "String has this value: " + str));
    }

    protected CmisTestResult assertStringNotEmpty(String str, CmisTestResult success, CmisTestResult failure) {
        if (str != null && str.length() > 0) {
            return success;
        }
        if (str == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "String is null!"));
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "String is empty!"));
    }

    protected CmisTestResult assertListNotEmpty(List<?> list, CmisTestResult success, CmisTestResult failure) {
        if (list != null && !list.isEmpty()) {
            return success;
        }
        if (list == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "List is null!"));
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "List is empty!"));
    }

    protected CmisTestResult assertListNullOrEmpty(List<?> list, CmisTestResult success, CmisTestResult failure) {
        if (list == null || list.isEmpty()) {
            return success;
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "List is not empty!"));
    }

    protected CmisTestResult assertEquals(Object expected, Object actual, CmisTestResult success, CmisTestResult failure) {
        if (this.isEqual(expected, actual)) {
            return success;
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "expected: " + this.formatValue(expected) + " / actual: " + this.formatValue(actual)));
    }

    protected CmisTestResult assertContains(Collection<?> collection, Object value, CmisTestResult success, CmisTestResult failure) {
        if (collection == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Collection is null!"));
        }
        if (collection.contains(value)) {
            return success;
        }
        return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Collection does not contain '" + this.formatValue(value) + "'"));
    }

    protected CmisTestResult assertEqualLists(List<?> expected, List<?> actual, CmisTestResult success, CmisTestResult failure) {
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Expected list is null!"));
        }
        if (actual == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Actual list is null!"));
        }
        if (expected.size() != actual.size()) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "List sizes don't match! expected: " + expected.size() + " / actual: " + actual.size()));
        }
        for (int i = 0; i < expected.size(); ++i) {
            if (this.isEqual(expected.get(i), actual.get(i))) continue;
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "expected list item[" + i + "]: " + this.formatValue(expected.get(i)) + " / actual list item[" + i + "]: " + this.formatValue(actual.get(i))));
        }
        return success;
    }

    protected CmisTestResult assertEqualSet(Set<?> expected, Set<?> actual, CmisTestResult success, CmisTestResult failure) {
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Expected set is null!"));
        }
        if (actual == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Actual set is null!"));
        }
        if (expected.size() != actual.size()) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Set sizes don't match! expected: " + expected.size() + " / actual: " + actual.size()));
        }
        for (Object o : expected) {
            if (actual.contains(o)) continue;
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Item not in actual set: " + this.formatValue(o)));
        }
        return success;
    }
}

