/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.impl;

import java.io.File;
import java.io.PrintWriter;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.WrapperCmisTestGroup;
import org.apache.chemistry.opencmis.tck.report.TextReport;
import org.apache.chemistry.opencmis.tck.runner.AbstractRunner;
import org.junit.Assert;

public final class JUnitHelper {
    public static final String JUNIT_PARAMETERS = "org.apache.chemistry.opencmis.tck.junit.parameters";

    private JUnitHelper() {
    }

    public static void run(CmisTest test) throws Exception {
        JUnitHelper.run(new WrapperCmisTestGroup(test));
    }

    public static void run(CmisTestGroup group) throws Exception {
        JUnitRunner runner = new JUnitRunner();
        String parametersFile = System.getProperty(JUNIT_PARAMETERS);
        if (parametersFile == null) {
            runner.setParameters(null);
        } else {
            runner.loadParameters(new File(parametersFile));
        }
        runner.addGroup(group);
        runner.run(new JUnitProgressMonitor());
        TextReport report = new TextReport();
        report.createReport(runner.getParameters(), runner.getGroups(), new PrintWriter(System.out));
        JUnitHelper.checkForFailures(runner);
    }

    private static void checkForFailures(JUnitRunner runner) {
        for (CmisTestGroup group : runner.getGroups()) {
            for (CmisTest test : group.getTests()) {
                for (CmisTestResult result : test.getResults()) {
                    if (result.getStatus().getLevel() < CmisTestResultStatus.FAILURE.getLevel()) continue;
                    Assert.fail((String)result.getMessage());
                }
            }
        }
    }

    private static class JUnitProgressMonitor
    implements CmisTestProgressMonitor {
        private JUnitProgressMonitor() {
        }

        @Override
        public void startGroup(CmisTestGroup group) {
            System.out.println(group.getName() + " (" + group.getTests().size() + " tests)");
        }

        @Override
        public void endGroup(CmisTestGroup group) {
        }

        @Override
        public void startTest(CmisTest test) {
            System.out.println("  " + test.getName());
        }

        @Override
        public void endTest(CmisTest test) {
        }

        @Override
        public void message(String msg) {
            System.out.println(msg);
        }
    }

    private static class JUnitRunner
    extends AbstractRunner {
        private JUnitRunner() {
        }
    }
}

