/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;

public class ChangeTokenTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Change Token Test");
        this.setDescription("Creates a document and a folder and updates them with an outdated change token.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            this.runUpdateDocumentTest(session, testFolder);
            this.runContentTest(session, testFolder);
            this.runUpdateFolderTest(session, testFolder);
            this.runAddChildFolderTest(session, testFolder);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateDocumentTest(Session session, Folder testFolder) {
        Document doc = this.createDocument(session, testFolder, "update1.txt", "Hello World!");
        try {
            if (doc.getChangeToken() == null) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository does not provide change tokens for documents. Test skipped!"));
                return;
            }
            DocumentTypeDefinition type = (DocumentTypeDefinition)doc.getType();
            PropertyDefinition namePropDef = (PropertyDefinition)type.getPropertyDefinitions().get("cmis:name");
            if (namePropDef.getUpdatability() == Updatability.WHENCHECKEDOUT || !doc.getAllowableActions().getAllowableActions().contains(Action.CAN_UPDATE_PROPERTIES)) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Document name can't be changed. Test skipped!"));
                return;
            }
            HashMap<String, String> properties2 = new HashMap<String, String>();
            properties2.put("cmis:name", "update2.txt");
            ObjectId newId = doc.updateProperties(properties2, false);
            if (!doc.getId().equals(newId.getId())) {
                this.addResult(this.createResult(CmisTestResultStatus.INFO, "The repository created a new version. Change tokens are not relevant here."));
            } else {
                try {
                    HashMap<String, String> properties3 = new HashMap<String, String>();
                    properties3.put("cmis:name", "update3.txt");
                    doc.updateProperties(properties3, false);
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Updating properties a second time with the same change token should result in an UpdateConflict exception!"));
                }
                catch (CmisUpdateConflictException e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.deleteObject((CmisObject)doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContentTest(Session session, Folder testFolder) {
        if (session.getRepositoryInfo().getCapabilities().getContentStreamUpdatesCapability() != CapabilityContentStreamUpdates.ANYTIME) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository doesn't allow to replace content. Test skipped!"));
            return;
        }
        Document doc = this.createDocument(session, testFolder, "content1.txt", "Hello World!");
        try {
            if (doc.getChangeToken() == null) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository does not provide change tokens for documents. Test skipped!"));
                return;
            }
            if (!doc.getAllowableActions().getAllowableActions().contains(Action.CAN_SET_CONTENT_STREAM)) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Document content can't be changed. Test skipped!"));
                return;
            }
            byte[] contentBytes = IOUtils.toUTF8Bytes((String)"New content");
            ContentStreamImpl contentStream = new ContentStreamImpl("content2.txt", BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
            ObjectId newId = doc.setContentStream((ContentStream)contentStream, true, false);
            if (newId == null) {
                if (Boolean.TRUE.equals(((DocumentTypeDefinition)doc.getType()).isVersionable())) {
                    List versions = doc.getAllVersions();
                    if (versions == null || versions.size() < 1) {
                        this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Repository returned an empty list of document versions!"));
                    } else {
                        newId = (ObjectId)versions.get(0);
                    }
                } else {
                    newId = doc;
                }
            }
            if (newId != null) {
                if (!doc.getId().equals(newId.getId())) {
                    this.addResult(this.createResult(CmisTestResultStatus.INFO, "The repository created a new version. Change tokens are not relevant here."));
                } else {
                    try {
                        doc.setContentStream((ContentStream)contentStream, true, false);
                        this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Updating content a second time with the same change token should result in an UpdateConflict exception!"));
                    }
                    catch (CmisUpdateConflictException uce) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.deleteObject((CmisObject)doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateFolderTest(Session session, Folder testFolder) {
        Folder folder = this.createFolder(session, testFolder, "folder1");
        try {
            if (folder.getChangeToken() == null) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository does not provide change tokens for folders. Test skipped!"));
                return;
            }
            if (!folder.getAllowableActions().getAllowableActions().contains(Action.CAN_UPDATE_PROPERTIES)) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Folder name can't be changed. Test skipped!"));
                return;
            }
            HashMap<String, String> properties2 = new HashMap<String, String>();
            properties2.put("cmis:name", "folder2");
            folder.updateProperties(properties2, false);
            try {
                HashMap<String, String> properties3 = new HashMap<String, String>();
                properties3.put("cmis:name", "folder3");
                folder.updateProperties(properties3, false);
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Updating properties a second time with the same change token should result in an UpdateConflict exception!"));
            }
            catch (CmisUpdateConflictException e) {
                // empty catch block
            }
        }
        finally {
            this.deleteObject((CmisObject)folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAddChildFolderTest(Session session, Folder testFolder) {
        Folder folder = this.createFolder(session, testFolder, "folder1");
        try {
            if (folder.getChangeToken() == null) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository does not provide change tokens for folders. Test skipped!"));
                return;
            }
            if (!folder.getAllowableActions().getAllowableActions().contains(Action.CAN_UPDATE_PROPERTIES)) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Folder name can't be changed. Test skipped!"));
                return;
            }
            this.createDocument(session, folder, "doc1", "content");
            try {
                HashMap<String, String> properties2 = new HashMap<String, String>();
                properties2.put("cmis:name", "folder2");
                folder.updateProperties(properties2, false);
            }
            catch (CmisUpdateConflictException e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Adding a child to a folder changes the change token of the folder. CMIS clients might not expect that."));
            }
        }
        finally {
            this.deleteObject((CmisObject)folder);
        }
    }
}

