/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

public class QueryRootFolderTest
extends AbstractQueryTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query Root Folder Test");
        this.setDescription("Performs a query that should return the root folder name and id.");
    }

    @Override
    public void run(Session session) {
        if (this.supportsQuery(session) && !this.isFulltextOnly(session)) {
            if (Boolean.TRUE.equals(session.getRootFolder().getType().isQueryable())) {
                this.queryById(session);
                this.queryByDate(session);
            } else {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Root folder type (" + session.getRootFolder().getType().getId() + ") is not queryable. Test Skipped!"));
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Metadata query not supported. Test Skipped!"));
        }
    }

    protected void queryById(Session session) {
        CmisTestResultImpl f;
        String testType = "cmis:folder";
        Folder rootFolder = session.getRootFolder();
        QueryStatement statement = session.createQueryStatement("SELECT ? AS folderName, ? AS folderId FROM ? WHERE ? = ?");
        statement.setProperty(1, testType, "cmis:name");
        statement.setProperty(2, testType, "cmis:objectId");
        statement.setType(3, testType);
        statement.setProperty(4, testType, "cmis:objectId");
        statement.setString(5, new String[]{rootFolder.getId()});
        this.addResult(this.createInfoResult("Query: " + statement.toQueryString()));
        int count = 0;
        ItemIterable results = statement.query(false);
        for (QueryResult qr : results) {
            ++count;
            String folderName = (String)qr.getPropertyValueByQueryName("folderName");
            String folderId = (String)qr.getPropertyValueByQueryName("folderId");
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query result does not match root folder name!");
            this.addResult(this.assertEquals(rootFolder.getName(), folderName, null, (CmisTestResult)f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query result does not match root folder id!");
            this.addResult(this.assertEquals(rootFolder.getId(), folderId, null, (CmisTestResult)f));
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "The query should return exactly one result but returned " + count + "!");
        this.addResult(this.assertEquals(1, count, null, (CmisTestResult)f));
        if (results.getTotalNumItems() >= 0L) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "The query returned a total number of items != 1, but there can be only exactly one hit!");
            this.addResult(this.assertEquals(1L, results.getTotalNumItems(), null, (CmisTestResult)f));
        }
    }

    protected void queryByDate(Session session) {
        CmisTestResultImpl f;
        String testType = "cmis:folder";
        Folder rootFolder = session.getRootFolder();
        GregorianCalendar before = new GregorianCalendar();
        before.setTimeInMillis(rootFolder.getCreationDate().getTimeInMillis() - 3600000L);
        GregorianCalendar after = new GregorianCalendar();
        after.setTimeInMillis(rootFolder.getCreationDate().getTimeInMillis() + 3600000L);
        QueryStatement statement = session.createQueryStatement("SELECT ? AS folderName, ? AS folderId FROM ? WHERE ? > TIMESTAMP ? AND ? < TIMESTAMP ?");
        statement.setProperty(1, testType, "cmis:name");
        statement.setProperty(2, testType, "cmis:objectId");
        statement.setType(3, testType);
        statement.setProperty(4, testType, "cmis:creationDate");
        statement.setDateTime(5, new Calendar[]{before});
        statement.setProperty(6, testType, "cmis:creationDate");
        statement.setDateTime(7, new Calendar[]{after});
        this.addResult(this.createInfoResult("Query: " + statement.toQueryString()));
        boolean found = false;
        ItemIterable results = statement.query(false);
        for (QueryResult qr : results) {
            String folderId = (String)qr.getPropertyValueByQueryName("folderId");
            if (!rootFolder.getId().equals(folderId)) continue;
            found = true;
            String folderName = (String)qr.getPropertyValueByQueryName("folderName");
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query result does not match root folder name!");
            this.addResult(this.assertEquals(rootFolder.getName(), folderName, null, (CmisTestResult)f));
            break;
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "The query should return the root folder but does not!");
        this.addResult(this.assertIsTrue(found, null, f));
        if (results.getTotalNumItems() >= 0L) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "The query returned a total number of items < 1, but there must be at least one hit!");
            this.addResult(this.assertIsTrue(results.getTotalNumItems() >= 1L, null, f));
        }
    }
}

