/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndDeleteFolderTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Folder Test");
    }

    @Override
    public void run(Session session) {
        CmisTestResultImpl f;
        Folder testFolder = this.createTestFolder(session);
        int numOfFolders = 100;
        HashMap<String, Folder> folders = new HashMap<String, Folder>();
        String[] propertiesToCheck = new String[]{"cmis:objectId", "cmis:baseTypeId", "cmis:objectTypeId"};
        for (int i = 0; i < numOfFolders; ++i) {
            Folder newFolder = this.createFolder(testFolder, "folder" + i);
            this.addResult(this.checkObject((CmisObject)newFolder, propertiesToCheck, "New folder object spec compliance. Id: " + newFolder.getId()));
            folders.put(newFolder.getId(), newFolder);
        }
        this.addResult(this.checkChildren(session, testFolder, "Test folder children check"));
        ItemIterable children = testFolder.getChildren();
        ArrayList<String> childrenIds = new ArrayList<String>();
        for (CmisObject child : children) {
            if (child == null) continue;
            childrenIds.add(child.getId());
            Folder folder = (Folder)folders.get(child.getId());
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder and test folder child don't match! Id: " + child.getId());
            this.addResult(this.assertShallowEquals((CmisObject)folder, child, null, f));
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Number of created folders does not match the number of existing folders!");
        this.addResult(this.assertEquals(numOfFolders, childrenIds.size(), null, (CmisTestResult)f));
        for (Folder folder : folders.values()) {
            if (childrenIds.contains(folder.getId())) continue;
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Created folder not found in test folder children! Id: " + folder.getId()));
        }
        for (Folder folder : folders.values()) {
            folder.delete(true);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not exist anymore but it is still there! Id: " + folder.getId());
            this.addResult(this.assertIsFalse(this.exists((CmisObject)folder), null, f));
        }
        this.deleteTestFolder();
        this.addResult(this.createInfoResult("Tested the creation and deletion of " + numOfFolders + " folders."));
    }
}

