/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.versioning;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedOutTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Checked out Test");
        this.setDescription("Calls getCheckedOutDocs() and checks the returned objects.");
    }

    @Override
    public void run(Session session) {
        int sessionCheckedOut = this.checkPWCs(session, (ItemIterable<Document>)session.getCheckedOutDocs(SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME));
        this.addResult(this.createInfoResult(sessionCheckedOut + " checked out documents overall."));
        int rootFolderCheckedOut = this.checkPWCs(session, (ItemIterable<Document>)session.getRootFolder().getCheckedOutDocs(SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME));
        this.addResult(this.createInfoResult(rootFolderCheckedOut + " checked out documents in the root folder."));
    }

    private int checkPWCs(Session session, ItemIterable<Document> pwcs) {
        CmisTestResultImpl f;
        if (pwcs == null) {
            return 0;
        }
        int i = 0;
        int orderByNameIssues = 0;
        String lastName = null;
        for (Document pwc : pwcs) {
            String[] propertiesToCheck = this.getAllProperties((CmisObject)pwc);
            this.addResult(this.checkObject(session, (CmisObject)pwc, propertiesToCheck, "PWC check: " + pwc.getId()));
            if (pwc != null) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "PWC is not latest version! Id: " + pwc.getId());
                this.addResult(this.assertIsTrue(pwc.isLatestVersion(), null, f));
                if (lastName != null && pwc.getName() != null && pwc.getName().compareToIgnoreCase(lastName) < 0) {
                    ++orderByNameIssues;
                }
                lastName = pwc.getName();
            }
            ++i;
        }
        f = this.createResult(CmisTestResultStatus.WARNING, "Checked-out documents should be ordered by cmis:name, but they are not! (It might be a collation mismtach.)");
        this.addResult(this.assertEquals(0, orderByNameIssues, null, (CmisTestResult)f));
        return i;
    }
}

