/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndDeleteDocumentTest
extends AbstractSessionTest {
    private static final String CONTENT = "TCK test content.";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Document Test");
        this.setDescription("Creates a few documents, checks the newly created documents and their parent and finally deletes the created documents.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        int numOfDocuments = 20;
        Folder testFolder = this.createTestFolder(session);
        try {
            CmisTestResultImpl f;
            HashMap<String, Document> documents = new HashMap<String, Document>();
            for (int i = 0; i < numOfDocuments; ++i) {
                Document newDocument = this.createDocument(session, testFolder, "doc" + i, CONTENT);
                documents.put(newDocument.getId(), newDocument);
            }
            this.addResult(this.checkChildren(session, testFolder, "Test folder children check"));
            ItemIterable children = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC);
            ArrayList<String> childrenIds = new ArrayList<String>();
            for (CmisObject child : children) {
                if (child == null) continue;
                childrenIds.add(child.getId());
                Document document = (Document)documents.get(child.getId());
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document and test folder child don't match! Id: " + child.getId());
                this.addResult(this.assertShallowEquals((CmisObject)document, child, null, f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of created folders does not match the number of existing folders!");
            this.addResult(this.assertEquals(numOfDocuments, childrenIds.size(), null, (CmisTestResult)f));
            for (Document document : documents.values()) {
                if (childrenIds.contains(document.getId())) continue;
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Created document not found in test folder children! Id: " + document.getId()));
            }
            int pageSize = 5;
            CmisObject lastObject = null;
            int count = 0;
            ItemIterable page1 = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME).getPage(pageSize);
            for (CmisObject child : page1) {
                ++count;
                lastObject = child;
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Returned number of children doesn't match the page size!");
            this.addResult(this.assertEquals(pageSize, count, null, (CmisTestResult)f));
            if (page1.getTotalNumItems() == -1L) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Repository did not return numItems for the first test page."));
            } else {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Returned numItems doesn't match the number of documents!");
                this.addResult(this.assertEquals(numOfDocuments, page1.getTotalNumItems(), null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "hasMoreItems of the first test page must be TRUE!");
            this.addResult(this.assertEquals(true, page1.getHasMoreItems(), null, (CmisTestResult)f));
            count = 0;
            ItemIterable page2 = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME).skipTo((long)(pageSize - 1)).getPage(pageSize);
            for (CmisObject child : page2) {
                if (++count != 1) continue;
                f = this.createResult(CmisTestResultStatus.FAILURE, "Last object of the first page doesn't match the first object of the second page.");
                this.addResult(this.assertEquals(lastObject.getId(), child.getId(), null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Returned number of children doesn't match the page size!");
            this.addResult(this.assertEquals(pageSize, count, null, (CmisTestResult)f));
            if (page2.getTotalNumItems() == -1L) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Repository did not return numItems for the second test page."));
            } else {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Returned numItems doesn't match the number of documents!");
                this.addResult(this.assertEquals(numOfDocuments, page2.getTotalNumItems(), null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "hasMoreItems of the second test page must be TRUE!");
            this.addResult(this.assertEquals(true, page2.getHasMoreItems(), null, (CmisTestResult)f));
            count = 0;
            ItemIterable page3 = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME).skipTo((long)(numOfDocuments - 5)).getPage(10);
            for (CmisObject child : page3) {
                ++count;
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Returned number of children should be 5 because page startetd at (numOfDocuments - 5).");
            this.addResult(this.assertEquals(5, count, null, (CmisTestResult)f));
            if (page3.getTotalNumItems() == -1L) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Repository did not return numItems for the third test page."));
            } else {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Returned numItems doesn't match the number of documents!");
                this.addResult(this.assertEquals(numOfDocuments, page3.getTotalNumItems(), null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "hasMoreItems of the third test page must be FALSE!");
            this.addResult(this.assertEquals(false, page3.getHasMoreItems(), null, (CmisTestResult)f));
            count = 0;
            ItemIterable pageNotExisting = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME).skipTo(100000L).getPage(pageSize);
            for (CmisObject child : pageNotExisting) {
                ++count;
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "The page size of a non-existing page must be 0!");
            this.addResult(this.assertEquals(0, count, null, (CmisTestResult)f));
            if (pageNotExisting.getTotalNumItems() == -1L) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Repository did not return numItems for a non-existing page."));
            } else {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Returned numItems doesn't match the number of documents!");
                this.addResult(this.assertEquals(numOfDocuments, pageNotExisting.getTotalNumItems(), null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "hasMoreItems of a non-existing page must be FALSE!");
            this.addResult(this.assertEquals(false, pageNotExisting.getHasMoreItems(), null, (CmisTestResult)f));
            for (Document document : documents.values()) {
                ContentStream contentStream = document.getContentStream();
                if (contentStream == null || contentStream.getStream() == null) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Document has no content! Id: " + document.getId()));
                    continue;
                }
                try {
                    contentStream.getStream().close();
                }
                catch (IOException e) {}
            }
            for (Document document : documents.values()) {
                document.delete(true);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not exist anymore but it is still there! Id: " + document.getId());
                this.addResult(this.assertIsFalse(this.exists((CmisObject)document), null, f));
            }
        }
        finally {
            this.deleteTestFolder();
        }
        this.addResult(this.createInfoResult("Tested the creation and deletion of " + numOfDocuments + " documents."));
    }
}

