/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndDeleteRelationshipTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Relationship Test");
        this.setDescription("Creates a relationship between two documents, checks the newly created relationship and finally deletes the created relationship.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.hasRelationships(session)) {
            Folder testFolder = this.createTestFolder(session);
            try {
                boolean found;
                Document doc1 = this.createDocument(session, testFolder, "doc1.txt", "doc1");
                Document doc2 = this.createDocument(session, testFolder, "doc2.txt", "doc2");
                Relationship rel = this.createRelationship(session, "rel1", (ObjectId)doc1, (ObjectId)doc2);
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Source document id does not match relationship source id!");
                this.addResult(this.assertEquals(doc1.getId(), rel.getSourceId().getId(), null, (CmisTestResult)f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Target document id does not match relationship target id!");
                this.addResult(this.assertEquals(doc2.getId(), rel.getTarget().getId(), null, (CmisTestResult)f));
                doc1.refresh();
                List doc1rels = doc1.getRelationships();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Source document has no relationships but must have at least one!");
                this.addResult(this.assertListNotEmpty(doc1rels, null, f));
                if (doc1rels != null) {
                    found = false;
                    for (Relationship r : doc1rels) {
                        if (!rel.getId().equals(r.getId())) continue;
                        found = true;
                        break;
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created relationship not found in the relationships of the source document!");
                    this.addResult(this.assertIsTrue(found, null, f));
                }
                found = false;
                for (Relationship r : session.getRelationships((ObjectId)doc1, true, RelationshipDirection.SOURCE, null, SELECT_ALL_NO_CACHE_OC)) {
                    if (!rel.getId().equals(r.getId())) continue;
                    found = true;
                    break;
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created relationship not found in the relationships returned by getObjectRelationships() for the source document!");
                this.addResult(this.assertIsTrue(found, null, f));
                doc2.refresh();
                List doc2rels = doc2.getRelationships();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Target document has no relationships but must have at least one!");
                this.addResult(this.assertListNotEmpty(doc2rels, null, f));
                if (doc2rels != null) {
                    found = false;
                    for (Relationship r : doc2rels) {
                        if (!rel.getId().equals(r.getId())) continue;
                        found = true;
                        break;
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created relationship not found in the relationships of the target document!");
                    this.addResult(this.assertIsTrue(found, null, f));
                }
                found = false;
                for (Relationship r : session.getRelationships((ObjectId)doc2, true, RelationshipDirection.TARGET, null, SELECT_ALL_NO_CACHE_OC)) {
                    if (!rel.getId().equals(r.getId())) continue;
                    found = true;
                    break;
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created relationship not found in the relationships returned by getObjectRelationships() for the target document!");
                this.addResult(this.assertIsTrue(found, null, f));
                this.deleteObject((CmisObject)rel);
                this.deleteObject((CmisObject)doc2);
                this.deleteObject((CmisObject)doc1);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Relationships not supported. Test Skipped!"));
        }
    }
}

