/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLSmokeTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("ACL Test");
        this.setDescription("Creates a document and checks its ACL.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsACLs(session)) {
            try {
                Folder testFolder = this.createTestFolder(session);
                Document doc = this.createDocument(session, testFolder, "acltest.txt", "ACL test");
                Acl acl = doc.getAcl();
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "ACLs are supported but newly created document has no ACL!");
                this.addResult(this.assertNotNull(acl, null, f));
                Acl basicAcl = session.getAcl((ObjectId)doc, true);
                f = this.createResult(CmisTestResultStatus.FAILURE, "ACLs are supported but repository does not return a basic ACL for the newly created document!");
                this.addResult(this.assertNotNull(basicAcl, null, f));
                if (basicAcl != null) {
                    this.addResult(this.checkACL(session, basicAcl, "Basic ACL"));
                    if (basicAcl.getAces() != null) {
                        for (Ace ace : basicAcl.getAces()) {
                            if (ace.getPermissions() == null) continue;
                            for (String permission : ace.getPermissions()) {
                                if ("cmis:read".equals(permission) || "cmis:write".equals(permission) || "cmis:all".equals(permission)) continue;
                                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "ACE contains a non-basic permission: " + permission));
                            }
                        }
                    }
                }
                if (this.getAclCapability(session) == CapabilityAcl.MANAGE) {
                    String principal = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.principal");
                    if (principal == null) {
                        principal = "cmis:user";
                    }
                    ArrayList<Ace> aces = new ArrayList<Ace>();
                    aces.add(session.getObjectFactory().createAce(principal, Collections.singletonList("cmis:write")));
                    session.applyAcl((ObjectId)doc, aces, null, null);
                    if (session.getRepositoryInfo().getAclCapabilities().getAclPropagation() != AclPropagation.REPOSITORYDETERMINED) {
                        aces = new ArrayList();
                        aces.add(session.getObjectFactory().createAce(principal, Collections.singletonList("cmis:all")));
                        session.setAcl((ObjectId)doc, aces);
                    }
                }
                this.deleteObject((CmisObject)doc);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "ACLs are not supported. Test Skipped!"));
        }
    }

    protected boolean supportsACLs(Session session) {
        CapabilityAcl aclCap = this.getAclCapability(session);
        return aclCap != null && aclCap != CapabilityAcl.NONE;
    }

    protected CapabilityAcl getAclCapability(Session session) {
        RepositoryInfo repository = session.getRepositoryInfo();
        if (repository.getCapabilities().getAclCapability() == null) {
            return null;
        }
        return repository.getCapabilities().getAclCapability();
    }
}

