/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.types;

import java.util.ArrayList;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.CreatablePropertyTypes;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndDeleteTypeTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Type Test");
        this.setDescription("Creates a document type and deletes it again.");
    }

    @Override
    public void run(Session session) {
        if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Type mutability is not supported by CMIS 1.0. Test skipped!"));
            return;
        }
        ObjectType parentType = session.getTypeDefinition(this.getDocumentTestTypeId());
        if (parentType.getTypeMutability() == null || !Boolean.TRUE.equals(parentType.getTypeMutability().canCreate())) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Test document type doesn't allow creating a sub-type. Test skipped!"));
            return;
        }
        this.createTypeWithoutProperties(session, parentType);
        this.createTypeWithProperties(session, parentType);
    }

    private void createTypeWithoutProperties(Session session, ObjectType parentType) {
        CmisTestResultImpl failure = null;
        DocumentTypeDefinitionImpl newTypeDef = this.createDocumentTypeDefinition("tck:testid_without_properties", parentType);
        ObjectType newType = this.createType(session, (TypeDefinition)newTypeDef);
        if (newType == null) {
            return;
        }
        ObjectType newType2 = null;
        try {
            newType2 = session.getTypeDefinition(newType.getId());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "The type definition returned by createType() doesn't match the type definition returned by getTypeDefinition()!");
            this.addResult(this.assertEquals((TypeDefinition)newType, (TypeDefinition)newType2, (CmisTestResult)null, (CmisTestResult)failure));
        }
        catch (CmisObjectNotFoundException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Newly created type can not be fetched. Id: " + newType.getId(), e, false));
        }
        this.deleteType(session, newType.getId());
    }

    private void createTypeWithProperties(Session session, ObjectType parentType) {
        CmisTestResultImpl failure = null;
        CreatablePropertyTypes cpt = session.getRepositoryInfo().getCapabilities().getCreatablePropertyTypes();
        if (cpt == null || cpt.canCreate() == null || cpt.canCreate().isEmpty()) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Repository Info does not indicate, which property types can be created!"));
            return;
        }
        DocumentTypeDefinitionImpl newTypeDef = this.createDocumentTypeDefinition("tck:testid_with_properties", parentType);
        for (PropertyType propType : PropertyType.values()) {
            if (!cpt.canCreate().contains(propType)) continue;
            newTypeDef.addPropertyDefinition(this.createPropertyDefinition(propType));
        }
        ObjectType newType = this.createType(session, (TypeDefinition)newTypeDef);
        if (newType == null) {
            return;
        }
        ObjectType newType2 = null;
        try {
            newType2 = session.getTypeDefinition(newType.getId());
            failure = this.createResult(CmisTestResultStatus.FAILURE, "The type definition returned by createType() doesn't match the type definition returned by getTypeDefinition()!");
            this.addResult(this.assertEquals((TypeDefinition)newType, (TypeDefinition)newType2, (CmisTestResult)null, (CmisTestResult)failure));
        }
        catch (CmisObjectNotFoundException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Newly created type can not be fetched. Id: " + newType.getId(), e, false));
        }
        ArrayList newPropDefs = new ArrayList();
        for (Map.Entry propDef : newType.getPropertyDefinitions().entrySet()) {
            if (!Boolean.FALSE.equals(((PropertyDefinition)propDef.getValue()).isInherited())) continue;
            newPropDefs.add(propDef.getValue());
        }
        failure = this.createResult(CmisTestResultStatus.FAILURE, "The number of defined properties and the number of non-inherited properties don't match!");
        this.addResult(this.assertEquals(newTypeDef.getPropertyDefinitions().size(), newPropDefs.size(), null, (CmisTestResult)failure));
        int i = 0;
        for (Map.Entry propDef : newTypeDef.getPropertyDefinitions().entrySet()) {
            PropertyDefinition newPropDef = (PropertyDefinition)newPropDefs.get(i);
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Property " + (i + 1) + " must be of type " + ((PropertyDefinition)propDef.getValue()).getPropertyType() + " but is of type " + newPropDef.getPropertyType() + "!");
            this.addResult(this.assertEquals(((PropertyDefinition)propDef.getValue()).getPropertyType(), newPropDef.getPropertyType(), null, (CmisTestResult)failure));
            this.addResult(this.createInfoResult("Repository assigned the property '" + ((PropertyDefinition)propDef.getValue()).getId() + "' the following property id: " + newPropDef.getId()));
            ++i;
        }
        this.deleteType(session, newType.getId());
    }

    private DocumentTypeDefinitionImpl createDocumentTypeDefinition(String typeId, ObjectType parentType) {
        DocumentTypeDefinitionImpl result = new DocumentTypeDefinitionImpl();
        result.setId(typeId);
        result.setBaseTypeId(parentType.getBaseTypeId());
        result.setParentTypeId(parentType.getId());
        result.setLocalName("tck:testlocal");
        result.setLocalNamespace("tck:testlocalnamespace");
        result.setDisplayName("TCK Document Type");
        result.setDescription("This is the TCK document type");
        result.setQueryName("tck:testqueryname");
        result.setIsQueryable(Boolean.valueOf(false));
        result.setIsFulltextIndexed(Boolean.valueOf(false));
        result.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        result.setIsControllableAcl(Boolean.valueOf(false));
        result.setIsControllablePolicy(Boolean.valueOf(false));
        result.setIsCreatable(Boolean.valueOf(true));
        result.setIsFileable(Boolean.valueOf(true));
        result.setIsVersionable(Boolean.valueOf(false));
        result.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        return result;
    }

    private AbstractPropertyDefinition<?> createPropertyDefinition(PropertyType propertyType) {
        PropertyBooleanDefinitionImpl result = null;
        switch (propertyType) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                result = new PropertyStringDefinitionImpl();
            }
        }
        result.setPropertyType(propertyType);
        result.setId("tck:" + propertyType.value());
        result.setLocalName("tck:local_" + propertyType.value());
        result.setLocalNamespace("tck:testlocalnamespace");
        result.setDisplayName("TCK " + propertyType.value() + " propertry");
        result.setQueryName("tck:" + propertyType.value());
        result.setDescription("TCK " + propertyType.value() + " propertry");
        result.setCardinality(Cardinality.SINGLE);
        result.setUpdatability(Updatability.READWRITE);
        result.setIsInherited(Boolean.valueOf(false));
        result.setIsQueryable(Boolean.valueOf(false));
        result.setIsOrderable(Boolean.valueOf(false));
        result.setIsRequired(Boolean.valueOf(false));
        result.setIsOpenChoice(Boolean.valueOf(true));
        return result;
    }
}

