/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.versioning;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningStateCreateTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Versioning State Create Test");
        this.setDescription("Creates documents in different versioning states.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Folder testFolder = this.createTestFolder(session);
            DocumentTypeDefinition docType = (DocumentTypeDefinition)session.getTypeDefinition(this.getDocumentTestTypeId());
            if (!docType.isVersionable().booleanValue()) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Test type is not versionable. Test skipped!"));
                return;
            }
            Document docMajor = testFolder.createDocument(this.getProperties("major.txt"), this.getContentStream(), VersioningState.MAJOR, null, null, null, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)docMajor, this.getAllProperties((CmisObject)docMajor), "Major version compliance"));
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Document should be major version.");
            this.addResult(this.assertIsTrue(docMajor.isMajorVersion(), null, f));
            List versions = docMajor.getAllVersions();
            f = this.createResult(CmisTestResultStatus.FAILURE, "Version series should have one version but has " + versions.size() + ".");
            this.addResult(this.assertEquals(1, versions.size(), null, (CmisTestResult)f));
            this.deleteObject((CmisObject)docMajor);
            try {
                Document docMinor = testFolder.createDocument(this.getProperties("minor.txt"), this.getContentStream(), VersioningState.MINOR, null, null, null, SELECT_ALL_NO_CACHE_OC);
                this.addResult(this.checkObject(session, (CmisObject)docMinor, this.getAllProperties((CmisObject)docMinor), "Minor version compliance"));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should be minor version.");
                this.addResult(this.assertIsFalse(docMinor.isMajorVersion(), null, f));
                versions = docMinor.getAllVersions();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version series should have one version but has " + versions.size() + ".");
                this.addResult(this.assertEquals(1, versions.size(), null, (CmisTestResult)f));
                this.deleteObject((CmisObject)docMinor);
            }
            catch (CmisConstraintException ce) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Creating a minor version failed! The repository might not support minor versions. Exception: " + (Object)((Object)ce), ce, false));
            }
            catch (CmisInvalidArgumentException iae) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Creating a minor version failed! The repository might not support minor versions.  Exception: " + (Object)((Object)iae), iae, false));
            }
            try {
                Document docCheckedOut = testFolder.createDocument(this.getProperties("checkout.txt"), this.getContentStream(), VersioningState.CHECKEDOUT, null, null, null, SELECT_ALL_NO_CACHE_OC);
                this.addResult(this.checkObject(session, (CmisObject)docCheckedOut, this.getAllProperties((CmisObject)docCheckedOut), "Checked out version compliance"));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version series should be checked out.");
                this.addResult(this.assertIsTrue(docCheckedOut.isVersionSeriesCheckedOut(), null, f));
                versions = docCheckedOut.getAllVersions();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version series should have one version but has " + versions.size() + ".");
                this.addResult(this.assertEquals(1, versions.size(), null, (CmisTestResult)f));
                docCheckedOut.cancelCheckOut();
            }
            catch (CmisConstraintException ce) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Creating a checked out version failed! The repository might not support creating checked out versions. Exception: " + (Object)((Object)ce), ce, false));
            }
            catch (CmisInvalidArgumentException iae) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Creating a checked out version failed! The repository might not  support creating checked out versions.  Exception: " + (Object)((Object)iae), iae, false));
            }
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private Map<String, Object> getProperties(String name) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", this.getDocumentTestTypeId());
        return properties;
    }

    private ContentStream getContentStream() {
        byte[] contentBytes = null;
        try {
            contentBytes = "some content".getBytes("UTF-8");
        }
        catch (Exception e) {
            contentBytes = "some content".getBytes();
        }
        return new ContentStreamImpl("content.txt", BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
    }
}

