/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.ontologiesplugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.clerezza.rdf.schemagen.SchemaGen;
import org.apache.clerezza.rdf.schemagen.SchemaGenArguments;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class OntologyJavaClassCreatorMojo
extends AbstractMojo {
    private String baseDir;
    private String resourcePath;
    private Properties namespaceOfOntology;
    private File[] sources;
    private MavenProject project;
    private Map<String, String> supportedFormats = new HashMap<String, String>();

    public void execute() throws MojoExecutionException {
        this.supportedFormats.put(".nt", "text/rdf+nt");
        this.supportedFormats.put(".n3", "text/rdf+n3");
        this.supportedFormats.put(".rdf", "application/rdf+xml");
        this.supportedFormats.put(".ttl", "text/turtle");
        this.supportedFormats.put(".turtle", "text/turtle");
        File file = null;
        if (this.resourcePath == null) {
            this.resourcePath = this.baseDir + File.separator + "src" + File.separator + "main" + File.separator + "ontologies";
        } else if (this.resourcePath.contains("/")) {
            this.resourcePath = this.resourcePath.replace("/", File.separator);
        } else if (this.resourcePath.contains("\\")) {
            this.resourcePath = this.resourcePath.replace("\\", File.separator);
        }
        file = new File(this.resourcePath);
        this.checkDir(file);
        if (this.sources != null) {
            for (int i = 0; i < this.sources.length; ++i) {
                this.project.addCompileSourceRoot(this.sources[i].getAbsolutePath());
                this.getLog().info((CharSequence)("Source directory: " + this.sources[i] + " added."));
            }
        }
    }

    private void checkDir(File ontologiesDir) {
        for (File file : ontologiesDir.listFiles()) {
            String fileEnding;
            if (file.isDirectory()) {
                this.checkDir(file);
                continue;
            }
            String fileName = file.getName();
            int indexOfLastDot = fileName.lastIndexOf(".");
            if (indexOfLastDot == -1 || !this.supportedFormats.containsKey(fileEnding = fileName.substring(indexOfLastDot))) continue;
            this.createJavaClassFile(file, fileEnding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJavaClassFile(final File file, final String fileEnding) {
        SchemaGen schemaGen;
        final String fileName = file.getName();
        String absolutePath = file.getAbsolutePath();
        String className = fileName.replace(fileEnding, "").toUpperCase();
        String pathToJavaClass = absolutePath.substring(absolutePath.indexOf(this.resourcePath) + this.resourcePath.length() + 1).replace(fileName, "");
        final String packageName = pathToJavaClass.replace(File.separator, ".") + className;
        SchemaGenArguments arguments = new SchemaGenArguments(){

            public URL getSchemaUrl() {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    OntologyJavaClassCreatorMojo.this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                    return null;
                }
            }

            public String getNamespace() {
                if (OntologyJavaClassCreatorMojo.this.namespaceOfOntology != null && OntologyJavaClassCreatorMojo.this.namespaceOfOntology.containsKey(fileName)) {
                    return OntologyJavaClassCreatorMojo.this.namespaceOfOntology.getProperty(fileName);
                }
                return null;
            }

            public String getFormatIdentifier() {
                return (String)OntologyJavaClassCreatorMojo.this.supportedFormats.get(fileEnding);
            }

            public String getClassName() {
                return packageName;
            }
        };
        try {
            schemaGen = new SchemaGen(arguments);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
        catch (URISyntaxException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
        String rootPath = this.baseDir + File.separator + "target" + File.separator + "generated-sources" + File.separator + "main" + File.separator + "java" + File.separator;
        File dir = new File(rootPath + pathToJavaClass);
        dir.mkdirs();
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File(rootPath + pathToJavaClass + className + ".java"), "utf-8");
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
        catch (UnsupportedEncodingException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new RuntimeException("utf-8 not supported!");
        }
        try {
            schemaGen.writeClass(out);
        }
        finally {
            out.flush();
        }
    }
}

