/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.serializer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.OutputStream;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.serializedform.SerializingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedSerializationFormatException;
import org.apache.clerezza.rdf.jena.facade.JenaGraph;

@SupportedFormat(value={"application/rdf+xml", "text/turtle", "application/x-turtle", "text/rdf+nt", "text/rdf+n3"})
public class JenaSerializerProvider
implements SerializingProvider {
    public void serialize(OutputStream serializedGraph, TripleCollection tc, String formatIdentifier) {
        String jenaFormat = this.getJenaFormat(formatIdentifier);
        JenaGraph graph = new JenaGraph(tc);
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        RDFWriter writer = model.getWriter(jenaFormat);
        if ("RDF/XML".equals(jenaFormat)) {
            writer.setProperty("allowBadURIs", (Object)Boolean.TRUE);
        }
        writer.write(model, serializedGraph, "");
    }

    private String getJenaFormat(String formatIdentifier) {
        int semicolonPos = formatIdentifier.indexOf(59);
        if (semicolonPos > -1) {
            formatIdentifier = formatIdentifier.substring(0, semicolonPos);
        }
        if (formatIdentifier.equals("application/rdf+xml")) {
            return "RDF/XML";
        }
        if (formatIdentifier.equals("text/turtle") || formatIdentifier.equals("application/x-turtle")) {
            return "TURTLE";
        }
        if (formatIdentifier.equals("text/rdf+n3")) {
            return "N3";
        }
        if (formatIdentifier.equals("text/rdf+nt")) {
            return "N-TRIPLE";
        }
        throw new UnsupportedSerializationFormatException(formatIdentifier);
    }
}

