/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.jaxrs.extensions.HttpRequest;
import org.apache.clerezza.jaxrs.extensions.MethodResponse;
import org.apache.clerezza.jaxrs.extensions.ResourceMethodException;
import org.apache.clerezza.jaxrs.extensions.RootResourceExecutor;
import org.apache.clerezza.jaxrs.extensions.prefixmanager.BundlePrefixManager;
import org.apache.clerezza.triaxrs.NoMatchingRootResourceException;
import org.apache.clerezza.triaxrs.ProcessableResponse;
import org.apache.clerezza.triaxrs.ResponseProcessor;
import org.apache.clerezza.triaxrs.RootResourceDescriptor;
import org.apache.clerezza.triaxrs.RootResourceExecutorImpl;
import org.apache.clerezza.triaxrs.RootResources;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.WebRequestImpl;
import org.apache.clerezza.triaxrs.providers.AggregatedProviders;
import org.apache.clerezza.triaxrs.providers.CascadingProviders;
import org.apache.clerezza.triaxrs.providers.DefaultProviders;
import org.apache.clerezza.triaxrs.providers.ProvidersImpl;
import org.apache.clerezza.triaxrs.util.MethodUtil;
import org.apache.clerezza.triaxrs.util.PathMatching;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.Handler;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.HeaderName;
import org.wymiwyg.wrhapi.MessageBody;
import org.wymiwyg.wrhapi.Request;
import org.wymiwyg.wrhapi.RequestURI;
import org.wymiwyg.wrhapi.ResponseStatus;
import org.wymiwyg.wrhapi.util.MessageBody2Read;

public class JaxRsHandler
implements Handler {
    private static Logger logger = LoggerFactory.getLogger(JaxRsHandler.class);
    Application applicationConfig;
    private RootResourceExecutor resourceExecutor;
    private Set<ServiceReference> applicationReferenceStore = new HashSet<ServiceReference>();
    Set<ServiceReference> componentReferenceStore = new HashSet<ServiceReference>();
    private RootResources rootResources;
    Collection<RootResourceDescriptor> applicationProvidedDescriptors = new ArrayList<RootResourceDescriptor>();
    private static ReentrantReadWriteLock configLock = new ReentrantReadWriteLock();
    public static final AggregatedProviders providers = new AggregatedProviders(configLock, new Providers[0]);
    private CascadingProviders componentSpecifiedProviders = new CascadingProviders();
    private ComponentContext componentContext;
    private BundlePrefixManager prefixManager;
    private Map<Object, String> component2PathPrefixMap = new HashMap<Object, String>();
    public static ThreadLocal<WebRequest> localRequest = new ThreadLocal();
    private Set<HttpMethod> httpMethods = new HashSet<HttpMethod>();

    public JaxRsHandler() {
        Class[] defaultProviders = DefaultProviders.getDefaultProviders();
        ProvidersImpl builtInProviders = new ProvidersImpl(defaultProviders);
        providers.reset(this.componentSpecifiedProviders, builtInProviders);
        this.rootResources = new RootResources();
        this.resourceExecutor = new RootResourceExecutorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindBundlePrefixManager(BundlePrefixManager prefixManager) {
        logger.debug("Binding bundle prefix manager");
        configLock.writeLock().lock();
        try {
            this.prefixManager = prefixManager;
            this.registerFromStores();
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindBundlePrefixManager(BundlePrefixManager prefixManager) {
        logger.debug("Unbinding bundle prefix manager");
        configLock.writeLock().lock();
        try {
            this.prefixManager = null;
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindComponent(ServiceReference serviceReference) {
        logger.debug("Bind component of bundle {}", (Object)serviceReference.getBundle().getSymbolicName());
        configLock.writeLock().lock();
        try {
            if (this.componentContext != null && this.prefixManager != null) {
                this.registerComponent(serviceReference);
            } else {
                this.componentReferenceStore.add(serviceReference);
            }
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    private void registerComponent(ServiceReference serviceReference) {
        String bundlePathPrefix = this.prefixManager.getPrefix(serviceReference.getBundle());
        Object component = this.componentContext.getBundleContext().getService(serviceReference);
        if (component == null) {
            return;
        }
        this.registerComponent(component, bundlePathPrefix);
        this.component2PathPrefixMap.put(component, bundlePathPrefix);
    }

    protected void registerComponent(Object component, String pathPrefix) {
        Class<?> clazz = component.getClass();
        Path path = clazz.getAnnotation(Path.class);
        if (path == null) {
            if (clazz.getAnnotation(Provider.class) != null) {
                logger.info("Register provider {} to path {}", (Object)component.getClass().getName(), (Object)pathPrefix);
                this.componentSpecifiedProviders.addInstance(component, pathPrefix);
            } else {
                logger.warn("Ignoring component: {} (Not a root resource or provider)", component);
            }
        } else {
            logger.info("Register resource {} to path {}{}", new Object[]{component.getClass().getName(), pathPrefix, path.value()});
            this.collectHttpMethods(component.getClass());
            RootResourceDescriptor descriptor = new RootResourceDescriptor(clazz, component, pathPrefix + path.value(), providers);
            this.rootResources.add(descriptor);
        }
    }

    private void collectHttpMethods(Class<?> clazz) {
        Set<Method> annotatedMethods = MethodUtil.getAnnotatedMethods(clazz);
        for (Method method : annotatedMethods) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethod == null) continue;
                this.httpMethods.add(httpMethod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindComponent(ServiceReference serviceReference) {
        configLock.writeLock().lock();
        try {
            if (!this.componentReferenceStore.remove(serviceReference)) {
                Object component = this.componentContext.getBundleContext().getService(serviceReference);
                if (component == null) {
                    logger.warn("Failed to unregister {} as no service could be located", (Object)serviceReference);
                    return;
                }
                this.unregisterComponent(component, this.component2PathPrefixMap.get(component));
                this.component2PathPrefixMap.remove(component);
            }
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    protected void unregisterComponent(Object component, String pathPrefix) {
        Class<?> clazz = component.getClass();
        Path path = clazz.getAnnotation(Path.class);
        logger.info("Unbinding: {}", component);
        if (path != null) {
            RootResourceDescriptor descriptor = new RootResourceDescriptor(clazz, component, path.value(), providers);
            this.rootResources.remove(descriptor);
        } else if (clazz.getAnnotation(Provider.class) != null) {
            this.componentSpecifiedProviders.removeInstance(component, pathPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindApplicationConfig(ServiceReference serviceReference) {
        configLock.writeLock().lock();
        try {
            if (this.componentContext != null && this.prefixManager != null) {
                this.registerApplicationConfig(serviceReference);
            } else {
                this.applicationReferenceStore.add(serviceReference);
            }
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    private void registerApplicationConfig(ServiceReference serviceReference) {
        String bundlePathPrefix = this.prefixManager.getPrefix(serviceReference.getBundle());
        Application applicationConfigToRegister = (Application)this.componentContext.locateService("applicationConfig", serviceReference);
        if (applicationConfigToRegister == null) {
            return;
        }
        this.registerApplicationConfig(applicationConfigToRegister, bundlePathPrefix);
    }

    protected void registerApplicationConfig(Application applicationConfig, String pathPrefix) {
        logger.info("Binding application config: {} ({})", (Object)applicationConfig, applicationConfig.getClass());
        this.applicationConfig = applicationConfig;
        Providers[] delegates = providers.getDelegates();
        if (delegates.length != 2) {
            throw new RuntimeException("expecting service discovered and buil-in providers");
        }
        CascadingProviders applicationProviders = new CascadingProviders();
        providers.reset(applicationProviders, delegates[0], delegates[1]);
        Set<Class<?>> appProvidedClasses = applicationConfig.getClasses();
        for (Class<?> clazz : appProvidedClasses) {
            this.registerSingleComponentOfApplication(clazz, null, applicationProviders, pathPrefix);
        }
        Set<Object> singletons = applicationConfig.getSingletons();
        for (Object singleton : singletons) {
            Class<?> clazz = singleton.getClass();
            this.registerSingleComponentOfApplication(clazz, singleton, applicationProviders, pathPrefix);
        }
        logger.debug("Binding application config finished.");
    }

    protected void registerSingleComponentOfApplication(Class<?> clazz, Object instance, CascadingProviders applicationProviders, String pathPrefix) {
        Path path = clazz.getAnnotation(Path.class);
        if (path != null) {
            this.collectHttpMethods(clazz);
            String completePath = pathPrefix + path.value();
            RootResourceDescriptor rootResourceDescriptor = instance == null ? new RootResourceDescriptor(clazz, completePath) : new RootResourceDescriptor(clazz, instance, completePath, providers);
            this.rootResources.add(rootResourceDescriptor);
            this.applicationProvidedDescriptors.add(rootResourceDescriptor);
        } else if (clazz.getAnnotation(Provider.class) != null) {
            if (instance != null) {
                applicationProviders.addInstance(instance, pathPrefix);
            } else {
                applicationProviders.addClass(clazz, pathPrefix);
            }
        } else {
            logger.warn("Ignoring application component: {} (Not a root resource or provider)", clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindApplicationConfig(Application applicationConfig) {
        configLock.writeLock().lock();
        try {
            this.unregisterApplicationConfig(applicationConfig);
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    protected void unregisterApplicationConfig(Application applicationConfig) {
        logger.info("unbinding app config.");
        this.applicationConfig = null;
        Providers[] delegates = providers.getDelegates();
        if (delegates.length != 3) {
            throw new RuntimeException("expecting application provided, service discovered and buil-in providers");
        }
        providers.reset(delegates[1], delegates[2]);
        for (RootResourceDescriptor rootResourceDescriptor : this.applicationProvidedDescriptors) {
            this.rootResources.remove(rootResourceDescriptor);
        }
        this.applicationProvidedDescriptors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        configLock.writeLock().lock();
        try {
            this.componentContext = componentContext;
            this.registerFromStores();
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    private void registerFromStores() {
        if (this.componentContext != null && this.prefixManager != null) {
            for (ServiceReference appRef : this.applicationReferenceStore) {
                this.registerApplicationConfig(appRef);
            }
            this.applicationReferenceStore.clear();
            for (ServiceReference compRef : this.componentReferenceStore) {
                this.registerComponent(compRef);
            }
            this.componentReferenceStore.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request origRequest, org.wymiwyg.wrhapi.Response response) throws HandlerException {
        WebRequestImpl request = new WebRequestImpl(origRequest, providers);
        localRequest.set(request);
        try {
            ProcessableResponse processableResponse;
            MethodResponse methodResponse;
            RequestURI.Type type = request.getWrhapiRequest().getRequestURI().getType();
            org.wymiwyg.wrhapi.Method method = request.getWrhapiRequest().getMethod();
            if (RequestURI.Type.NO_RESOURCE.equals((Object)type) && org.wymiwyg.wrhapi.Method.OPTIONS.equals((Object)method)) {
                Response.ResponseBuilder builder = Response.ok();
                StringWriter sw = new StringWriter();
                Iterator<HttpMethod> iter = this.httpMethods.iterator();
                if (iter.hasNext()) {
                    for (int i = 0; i < this.httpMethods.size() - 1; ++i) {
                        HttpMethod httpMethod = iter.next();
                        sw.append(httpMethod.value());
                        sw.append(",");
                    }
                    sw.append(iter.next().value());
                }
                builder.header(HeaderName.ALLOW.toString(), sw.toString());
                methodResponse = this.getWildCardOptionsResponse();
            } else {
                RootResources.ResourceAndPathMatching resourceAndPathMatching;
                configLock.readLock().lock();
                try {
                    resourceAndPathMatching = this.rootResources.getResourceAndPathMatching(request);
                }
                finally {
                    configLock.readLock().unlock();
                }
                PathMatching pathMatching = resourceAndPathMatching.getPathMatching();
                methodResponse = this.resourceExecutor.execute((HttpRequest)request, resourceAndPathMatching.getRootResource(), pathMatching.getRemainingURIPath(), pathMatching.getParameters());
            }
            try {
                processableResponse = (ProcessableResponse)methodResponse;
            }
            catch (ClassCastException e) {
                throw new RuntimeException("processing of other MethodResponse implementations not yet supported");
            }
            ResponseProcessor.handleReturnValue(request, response, processableResponse);
        }
        catch (ResourceMethodException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                logger.error("Exception {}", (Throwable)ex);
            } else {
                JaxRsHandler.handleException(cause, request, response);
            }
        }
        catch (NoMatchingRootResourceException e) {
            response.setResponseStatus(ResponseStatus.NOT_FOUND);
            response.setBody((MessageBody)new MessageBody2Read(){

                public ReadableByteChannel read() throws IOException {
                    return Channels.newChannel(new ByteArrayInputStream(("JaxRsHandler - " + JaxRsHandler.this.rootResources.size() + " root resource descriptor registered").getBytes()));
                }
            });
        }
        catch (Exception ex) {
            JaxRsHandler.handleException(ex, request, response);
        }
    }

    static void handleException(Throwable exception, WebRequest request, org.wymiwyg.wrhapi.Response response) throws HandlerException, RuntimeException {
        ExceptionMapper<?> exMapper;
        Response jaxResponse;
        if (exception instanceof WebApplicationException) {
            ExceptionMapper<?> exMapper2;
            WebApplicationException webEx = (WebApplicationException)exception;
            logger.debug("Exception {}", (Throwable)webEx);
            jaxResponse = webEx.getResponse();
            if ((jaxResponse == null || jaxResponse.getEntity() == null) && (exMapper2 = providers.getExceptionMapper(webEx.getClass())) != null) {
                jaxResponse = exMapper2.toResponse(webEx);
            }
            try {
                ResponseProcessor.processJaxResponse(request, response, jaxResponse, null, Collections.singleton(MediaType.valueOf("text/html")));
                return;
            }
            catch (IOException ex1) {
                logger.info("Exception processing response from WebApplicationException", (Throwable)ex1);
            }
        }
        if ((exMapper = providers.getExceptionMapper(exception.getClass())) != null) {
            logger.info("Exception with exception mapper", exception);
            try {
                jaxResponse = exMapper.toResponse(exception);
            }
            catch (Exception ex1) {
                jaxResponse = Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            try {
                ResponseProcessor.processJaxResponse(request, response, jaxResponse, null, Collections.singleton(MediaType.valueOf("text/html")));
            }
            catch (IOException ex1) {
                logger.info("Exception processing response from exception mapper", (Throwable)ex1);
            }
        } else {
            if (exception instanceof RuntimeException) {
                if (!(exception instanceof AccessControlException)) {
                    logger.warn("RuntimeException (with no exception mapper)", exception);
                } else {
                    logger.info("AccessControlException (will rethrow)", exception);
                }
                throw (RuntimeException)exception;
            }
            logger.warn("Exception (with no exception mapper)", exception);
            throw new HandlerException(exception);
        }
    }

    private MethodResponse getWildCardOptionsResponse() {
        Response.ResponseBuilder builder = Response.ok();
        StringWriter sw = new StringWriter();
        Iterator<HttpMethod> iter = this.httpMethods.iterator();
        if (iter.hasNext()) {
            for (int i = 0; i < this.httpMethods.size() - 1; ++i) {
                HttpMethod httpMethod = iter.next();
                sw.append(httpMethod.value());
                sw.append(",");
            }
            sw.append(iter.next().value());
        }
        builder.header(HeaderName.ALLOW.toString(), sw.toString());
        return ProcessableResponse.createProcessableResponse(builder.build(), null, null, null, null);
    }

    protected void bindResourceExecutor(RootResourceExecutor rootResourceExecutor) {
        this.resourceExecutor = rootResourceExecutor;
    }

    protected void unbindResourceExecutor(RootResourceExecutor rootResourceExecutor) {
        if (this.resourceExecutor == rootResourceExecutor) {
            this.resourceExecutor = null;
        }
    }
}

