/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import javax.security.auth.Subject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.clerezza.triaxrs.JaxRsHandler;
import org.apache.clerezza.triaxrs.ProcessableResponse;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.providers.provided.JafMessageBodyWriter;
import org.apache.clerezza.triaxrs.util.AcceptHeader;
import org.apache.clerezza.triaxrs.util.BodyStoringResponse;
import org.apache.clerezza.triaxrs.util.FirstByteActionOutputStream;
import org.apache.clerezza.triaxrs.util.InconsistentMediaTypeComparator;
import org.apache.clerezza.triaxrs.util.MediaTypeComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.HeaderName;
import org.wymiwyg.wrhapi.MessageBody;
import org.wymiwyg.wrhapi.ResponseStatus;
import org.wymiwyg.wrhapi.util.MessageBody2Write;

class ResponseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ResponseProcessor.class);

    ResponseProcessor() {
    }

    static void handleReturnValue(WebRequest request, org.wymiwyg.wrhapi.Response response, ProcessableResponse processableResponse) throws HandlerException {
        try {
            Annotation[] annotations = processableResponse.getAnnotations();
            Set<MediaType> methodProducibleMediaTypes = processableResponse.getMethodProducibleTypes();
            ResponseProcessor.processJaxResponse(request, response, (Response)((Object)processableResponse), annotations, methodProducibleMediaTypes);
        }
        catch (IOException ex) {
            throw new HandlerException((Throwable)ex);
        }
    }

    static void processJaxResponse(final WebRequest request, final org.wymiwyg.wrhapi.Response response, Response jaxResponse, final Annotation[] annotations, Set<MediaType> methodProducibleMediaTypes) throws HandlerException, IOException {
        List contentTypeList;
        MediaType mediaType3;
        Type entityType;
        Object entity = jaxResponse.getEntity();
        final MultivaluedMap<String, Object> headerMap = jaxResponse.getMetadata();
        int responseStatus = jaxResponse.getStatus();
        if (responseStatus == -1) {
            responseStatus = ResponseStatus.SUCCESS.getCode();
        }
        if (entity == null) {
            response.setHeader(HeaderName.CONTENT_LENGTH, (Object)0);
            if (responseStatus == ResponseStatus.SUCCESS.getCode()) {
                response.setResponseStatus(ResponseStatus.NO_CONTENT);
                ResponseProcessor.flushHeaders(headerMap, response);
                return;
            }
            if (responseStatus > 400) {
                entity = ResponseProcessor.getExplanation(responseStatus);
                headerMap.putSingle("Content-Type", MediaType.TEXT_HTML_TYPE);
            } else {
                response.setResponseStatus(ResponseStatus.getInstanceByCode((int)responseStatus));
                ResponseProcessor.flushHeaders(headerMap, response);
                return;
            }
        }
        if (entity instanceof GenericEntity) {
            entityType = ((GenericEntity)entity).getType();
            entity = ((GenericEntity)entity).getEntity();
        } else {
            entityType = null;
        }
        ArrayList<MediaType> methodProducibleMediaTypesList = new ArrayList<MediaType>(methodProducibleMediaTypes);
        AcceptHeader acceptHeader = request.getAcceptHeader();
        if (methodProducibleMediaTypesList.size() == 0) {
            methodProducibleMediaTypesList.add(MediaType.WILDCARD_TYPE);
        }
        List<MediaType> expandedMethodProducibleMediaTypesList = ResponseProcessor.expandListWithConcreterTypesFromAccept(methodProducibleMediaTypesList, acceptHeader);
        MessageBodyWriter<Object> writer = null;
        List<Set<MediaType>> expandedMethodProducibleMediaTypeClasses = ResponseProcessor.getSortedClasses(expandedMethodProducibleMediaTypesList, new InconsistentMediaTypeComparator(acceptHeader));
        Collections.sort(methodProducibleMediaTypesList, new MediaTypeComparator(acceptHeader));
        MediaType relevantMethodProducibleType = null;
        for (Set<MediaType> preferenceClass : expandedMethodProducibleMediaTypeClasses) {
            int lastWriterConcreteness = -1;
            for (MediaType mediaType2 : preferenceClass) {
                int writerConcreteness;
                MessageBodyWriter<Object> currentWriter = JaxRsHandler.providers.getMessageBodyWriter(entity.getClass(), entityType, annotations, mediaType2);
                if (currentWriter == null || (writerConcreteness = ResponseProcessor.getWriterConcreteness(currentWriter, mediaType2)) <= lastWriterConcreteness) continue;
                for (MediaType methodMediaType : methodProducibleMediaTypesList) {
                    if (!methodMediaType.isCompatible(mediaType2)) continue;
                    relevantMethodProducibleType = methodMediaType;
                    break;
                }
                writer = currentWriter;
            }
            if (writer == null) continue;
            break;
        }
        if (writer == null) {
            for (MediaType mediaType3 : expandedMethodProducibleMediaTypesList) {
                try {
                    writer = new JafMessageBodyWriter<Object>(entity, mediaType3);
                }
                catch (UnsupportedDataTypeException ex) {
                    logger.debug("No JafMessageBodyWriter for {}", (Object)mediaType3);
                }
                if (writer == null) continue;
                relevantMethodProducibleType = mediaType3;
                break;
            }
        }
        if (writer == null) {
            Response r = Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("No suitable MessageBodyWriter available").type(MediaType.TEXT_PLAIN_TYPE).build();
            throw new WebApplicationException(r);
        }
        MediaType relevantProducibleType = null;
        if (relevantMethodProducibleType == null || MediaTypeComparator.countWildChars(relevantMethodProducibleType) > 0) {
            List<MediaType> writerProducibleMediaTypes = ResponseProcessor.getWriterProduces(writer);
            Collections.sort(writerProducibleMediaTypes, new MediaTypeComparator(acceptHeader));
            if (relevantMethodProducibleType != null) {
                for (MediaType currentProducible : writerProducibleMediaTypes) {
                    if (!relevantMethodProducibleType.isCompatible(currentProducible)) continue;
                    relevantProducibleType = MediaTypeComparator.compareByWildCardCount(relevantMethodProducibleType, currentProducible) == 1 ? currentProducible : relevantMethodProducibleType;
                    break;
                }
            } else {
                relevantProducibleType = writerProducibleMediaTypes.get(0);
            }
        } else {
            relevantProducibleType = relevantMethodProducibleType;
        }
        if (relevantProducibleType == null) {
            throw new RuntimeException("The relevantMethodProducibleType " + relevantMethodProducibleType + " is not compatible with any of the producible types of " + writer);
        }
        if (MediaTypeComparator.countWildChars(relevantProducibleType) == 0) {
            mediaType3 = relevantProducibleType;
        } else {
            mediaType3 = relevantProducibleType;
            for (MediaType acceptType : acceptHeader.getEntries()) {
                if (!acceptType.isCompatible(relevantProducibleType) || MediaTypeComparator.compareByWildCardCount(acceptType, mediaType3) != 1) continue;
                mediaType3 = acceptType;
            }
        }
        if (acceptHeader.getAcceptingMediaType(mediaType3).isEmpty() && !mediaType3.equals(MediaType.TEXT_HTML_TYPE)) {
            throw new WebApplicationException(406);
        }
        mediaType3 = ResponseProcessor.getConcreteMediaTypeFromPattern(mediaType3);
        response.setResponseStatus(ResponseStatus.getInstanceByCode((int)responseStatus));
        long size = writer.getSize(entity, entity.getClass(), entityType, annotations, mediaType3);
        if (size != -1L) {
            response.setHeader(HeaderName.CONTENT_LENGTH, (Object)size);
        }
        if ((contentTypeList = (List)jaxResponse.getMetadata().get("Content-Type")) != null && contentTypeList.size() > 0) {
            Object mediaTypeObject = contentTypeList.get(0);
            if (mediaTypeObject instanceof MediaType) {
                mediaType3 = (MediaType)mediaTypeObject;
            } else {
                String mediaTypeString = ResponseProcessor.getStringValueFromHeader(mediaTypeObject);
                mediaType3 = MediaType.valueOf(mediaTypeString);
            }
        } else {
            headerMap.add("Content-Type", mediaType3);
        }
        final MessageBodyWriter<Object> finalWriter = writer;
        final Object finalEntity = entity;
        final MediaType finalMediaType = mediaType3;
        response.setBody((MessageBody)new MessageBody2Write(){
            AccessControlContext context = AccessController.getContext();
            Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    return Subject.getSubject(context);
                }
            });

            public void writeTo(final WritableByteChannel out) throws IOException {
                final FirstByteActionOutputStream headerFlushingOutputStream = new FirstByteActionOutputStream(Channels.newOutputStream(out), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ResponseProcessor.setDefaultCacheControlHeader(headerMap);
                            ResponseProcessor.flushHeaders(headerMap, response);
                        }
                        catch (HandlerException ex) {
                            logger.error("Exception {}", (Object)ex.toString(), (Object)ex);
                        }
                    }
                });
                if (this.subject != null) {
                    try {
                        Subject.doAs(this.subject, new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                this.writeTo(headerFlushingOutputStream, out);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new RuntimeException(cause);
                    }
                } else {
                    this.writeTo(headerFlushingOutputStream, out);
                }
            }

            private void writeTo(OutputStream firstByteActionOut, final WritableByteChannel out) throws IOException {
                block9: {
                    try {
                        finalWriter.writeTo(finalEntity, finalEntity.getClass(), entityType, annotations, finalMediaType, headerMap, firstByteActionOut);
                        firstByteActionOut.close();
                        JaxRsHandler.localRequest.remove();
                    }
                    catch (Exception ex) {
                        try {
                            BodyStoringResponse responseFake = new BodyStoringResponse(response);
                            JaxRsHandler.handleException(ex, request, responseFake);
                            final MessageBody body = responseFake.getBody();
                            if (body == null) break block9;
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Subject run() throws IOException {
                                        body.writeTo(out);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privEx) {
                                Throwable cause = privEx.getCause();
                                if (cause instanceof IOException) {
                                    throw (IOException)cause;
                                }
                                if (cause instanceof RuntimeException) {
                                    throw (RuntimeException)cause;
                                }
                                if (cause instanceof Error) {
                                    throw (Error)cause;
                                }
                                throw new RuntimeException(cause);
                            }
                        }
                        catch (HandlerException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
    }

    private static List<MediaType> expandListWithConcreterTypesFromAccept(List<MediaType> mediaTypesList, AcceptHeader acceptHeader) {
        HashSet<MediaType> addition = new HashSet<MediaType>();
        for (MediaType mediaType : mediaTypesList) {
            for (MediaType acceptingType : acceptHeader.getAcceptingMediaType(mediaType)) {
                if (MediaTypeComparator.compareByWildCardCount(acceptingType, mediaType) != -1) continue;
                addition.add(acceptingType);
            }
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        result.addAll(mediaTypesList);
        result.addAll(addition);
        return result;
    }

    private static String getExplanation(int responseStatus) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.println("<html>");
        out.println("<head>");
        out.print("<title>");
        out.print("Error: ");
        out.print(responseStatus);
        out.println("</title>");
        out.print("<body>");
        if (responseStatus >= 500) {
            ResponseProcessor.writeServerError(out, responseStatus);
        } else {
            ResponseProcessor.writeClientError(out, responseStatus);
        }
        out.print("</body>");
        out.println("</head>");
        out.println("</html>");
        return stringWriter.toString();
    }

    private static void writeServerError(PrintWriter out, int responseStatus) {
        out.println("<h1>Server error</h1>");
        out.println("<p>An error occurred and the server was unable to process your request. We apologize for the inconveniences</p>");
    }

    private static void writeClientError(PrintWriter out, int responseStatus) {
        if (responseStatus == 404) {
            out.println("<h1>Not found</h1>");
            out.println("<p>The requested resource does not exist on this server. Please check the entered address (URI). If you followed a link please inform the creator of the page containing the link.</p>");
        } else {
            out.println("<h1>Client error</h1>");
            out.println("<p>The server was unable to process your request. This might be caused by properties of your request incompatible with the capacities of the server for the requested resource.</p>");
        }
    }

    private static List<MediaType> getWriterProduces(MessageBodyWriter<?> writer) {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        Produces writerProduces = writer.getClass().getAnnotation(Produces.class);
        if (writerProduces != null) {
            for (String produced : writerProduces.value()) {
                MediaType producibleType = MediaType.valueOf(produced);
                result.add(producibleType);
            }
        } else {
            result.add(MediaType.WILDCARD_TYPE);
        }
        return result;
    }

    private static MessageBodyWriter<Object> getJafMethodBodyWriter(Object entity, List<MediaType> methodProducibleMediaTypesList) throws IOException {
        MediaType mediaType = methodProducibleMediaTypesList.size() > 0 ? methodProducibleMediaTypesList.get(0) : MediaType.WILDCARD_TYPE;
        try {
            return new JafMessageBodyWriter<Object>(entity, mediaType);
        }
        catch (UnsupportedDataTypeException ex) {
            Response r = Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("No suitable MessageBodyWriter available").type(MediaType.TEXT_PLAIN_TYPE).build();
            throw new WebApplicationException(r);
        }
    }

    private static void flushHeaders(MultivaluedMap<String, Object> headerMap, org.wymiwyg.wrhapi.Response response) throws HandlerException {
        for (String headerNameString : headerMap.keySet()) {
            List values = (List)headerMap.get(headerNameString);
            for (Object object : values) {
                String stringValue = ResponseProcessor.getStringValueFromHeader(object);
                response.setHeader(HeaderName.get((String)headerNameString), (Object)stringValue);
            }
        }
    }

    private static <T> String getStringValueFromHeader(T headerObject) {
        RuntimeDelegate.HeaderDelegate<?> headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(headerObject.getClass());
        String mediaTypeString = headerDelegate != null ? headerDelegate.toString(headerObject) : headerObject.toString();
        return mediaTypeString;
    }

    private static MediaType getConcreteMediaTypeFromPattern(MediaType mediaType) {
        if (mediaType.isWildcardSubtype()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        Map<String, String> params = mediaType.getParameters();
        if (!params.containsKey("q")) {
            return mediaType;
        }
        HashMap<String, String> resultParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.equals("q")) continue;
            resultParams.put(key, entry.getValue());
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), resultParams);
    }

    private static <T> List<Set<T>> getSortedClasses(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<Set<T>> result = new ArrayList<Set<T>>();
        if (collection.size() > 0) {
            HashSet<T> pivotSet = new HashSet<T>();
            ArrayList<T> before = new ArrayList<T>();
            ArrayList<T> after = new ArrayList<T>();
            Iterator<T> iterator = collection.iterator();
            T pivot = iterator.next();
            pivotSet.add(pivot);
            while (iterator.hasNext()) {
                T next = iterator.next();
                int comparison = comparator.compare(next, pivot);
                if (comparison > 0) {
                    after.add(next);
                    continue;
                }
                if (comparison < 0) {
                    before.add(next);
                    continue;
                }
                pivotSet.add(next);
            }
            result.addAll(ResponseProcessor.getSortedClasses(before, comparator));
            result.add(pivotSet);
            result.addAll(ResponseProcessor.getSortedClasses(after, comparator));
        }
        return result;
    }

    private static int getWriterConcreteness(MessageBodyWriter<Object> writer, MediaType mediaType) {
        Produces produces = writer.getClass().getAnnotation(Produces.class);
        int result = 0;
        if (produces != null) {
            for (String producedValue : produces.value()) {
                int concreteness;
                MediaType producesType = MediaType.valueOf(producedValue);
                if (!producesType.isCompatible(mediaType) || (concreteness = 2 - MediaTypeComparator.countWildChars(producesType)) <= result) continue;
                result = concreteness;
            }
        }
        return result;
    }

    private static void setDefaultCacheControlHeader(MultivaluedMap<String, Object> headerMap) {
        if (headerMap.containsKey(HeaderName.CACHE_CONTROL.toString()) || headerMap.containsKey(HeaderName.EXPIRES.toString()) || headerMap.containsKey(HeaderName.PRAGMA.toString()) || headerMap.containsKey(HeaderName.LAST_MODIFIED.toString()) || headerMap.containsKey("ETag")) {
            return;
        }
        headerMap.putSingle(HeaderName.CACHE_CONTROL.toString(), "no-cache");
    }
}

