/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.util.Map;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.InjectionUtilities;
import org.apache.clerezza.triaxrs.JaxRsHandler;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.WebRequestProxy;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.apache.clerezza.triaxrs.util.URITemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;

class RootResourceDescriptor
implements Comparable<RootResourceDescriptor> {
    private Class<?> clazz;
    private URITemplate uriTemplate;
    private Object instance;
    private Logger logger = LoggerFactory.getLogger(RootResourceDescriptor.class);

    public RootResourceDescriptor(Class<?> clazz, String pathTemplate) {
        this.uriTemplate = new URITemplate(pathTemplate);
        this.clazz = clazz;
    }

    public RootResourceDescriptor(Class<?> clazz, Object instance, String pathTemplate, Providers providers) {
        this.uriTemplate = new URITemplate(pathTemplate);
        this.clazz = clazz;
        this.instance = instance;
        if (instance != null) {
            try {
                WebRequest requestProxy = WebRequestProxy.createProxy();
                InjectionUtilities.injectFields(requestProxy, null, providers, instance);
            }
            catch (HandlerException ex) {
                this.logger.debug("Exception {}", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            catch (UnsupportedFieldType ex) {
                this.logger.debug("Exception {}", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public Object getInstance(WebRequest request, Map<String, String> pathParams) {
        if (this.instance != null) {
            return this.instance;
        }
        try {
            return InjectionUtilities.createPreparedInstance(request, pathParams, JaxRsHandler.providers, this.clazz);
        }
        catch (HandlerException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedFieldType e) {
            throw new RuntimeException(e);
        }
    }

    public URITemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RootResourceDescriptor other = (RootResourceDescriptor)obj;
        if (!(this.clazz == other.clazz || this.clazz != null && this.clazz.equals(other.clazz))) {
            return false;
        }
        if (!(this.uriTemplate == other.uriTemplate || this.uriTemplate != null && this.uriTemplate.equals(other.uriTemplate))) {
            return false;
        }
        return this.instance == other.instance || this.instance != null && this.instance.equals(other.instance);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        hash = 37 * hash + (this.instance != null ? this.instance.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(RootResourceDescriptor o) {
        int uriCompare = this.uriTemplate.compareTo(o.uriTemplate);
        if (uriCompare != 0) {
            return uriCompare;
        }
        if (this.instance != null && o.instance == null) {
            return -1;
        }
        if (o.instance != null && this.instance == null) {
            return 1;
        }
        return 0;
    }
}

