/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.clerezza.triaxrs.NoMatchingRootResourceException;
import org.apache.clerezza.triaxrs.RootResourceDescriptor;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.util.PathMatching;
import org.apache.clerezza.utils.UriException;
import org.apache.clerezza.utils.UriUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;

public class RootResources {
    private static ThreadLocal<String> requestUri = new ThreadLocal<String>(){};
    private static final Logger logger = LoggerFactory.getLogger(RootResources.class);
    SortedSet<RootResourceDescriptor> rootResourceDescriptors = new TreeSet<RootResourceDescriptor>();

    public static String getCurrentRequestUri() {
        return requestUri.get();
    }

    public void add(RootResourceDescriptor descriptor) {
        this.rootResourceDescriptors.add(descriptor);
    }

    public void remove(RootResourceDescriptor descriptor) {
        this.rootResourceDescriptors.remove(descriptor);
    }

    public int size() {
        return this.rootResourceDescriptors.size();
    }

    public RootResourceDescriptor getDescriptor(String uriPath) {
        for (RootResourceDescriptor descriptor : this.rootResourceDescriptors) {
            PathMatching pathMatching = descriptor.getUriTemplate().match(uriPath);
            if (pathMatching == null) continue;
            return descriptor;
        }
        return null;
    }

    ResourceAndPathMatching getResourceAndPathMatching(WebRequest request) throws HandlerException, NoMatchingRootResourceException {
        String uriPath;
        try {
            uriPath = UriUtil.encodePartlyEncodedPath((String)request.getWrhapiRequest().getRequestURI().getPath(), (String)"UTF-8");
        }
        catch (UriException ex) {
            throw new RuntimeException(ex);
        }
        requestUri.set(uriPath);
        PathMatching pathMatching = null;
        RootResourceDescriptor descriptor = null;
        Iterator descriptorIter = this.rootResourceDescriptors.iterator();
        while (descriptorIter.hasNext() && (pathMatching = (descriptor = (RootResourceDescriptor)descriptorIter.next()).getUriTemplate().match(uriPath)) == null) {
        }
        if (pathMatching == null) {
            throw new NoMatchingRootResourceException();
        }
        return new ResourceAndPathMatching(descriptor.getInstance(request, pathMatching.getParameters()), pathMatching);
    }

    public static class ResourceAndPathMatching {
        private Object rootResource;
        private PathMatching pathMatching;

        public ResourceAndPathMatching(Object rootResource, PathMatching pathMatching) {
            this.rootResource = rootResource;
            this.pathMatching = pathMatching;
        }

        public Object getRootResource() {
            return this.rootResource;
        }

        public PathMatching getPathMatching() {
            return this.pathMatching;
        }
    }
}

