/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.providers.provided.JafMessageBodyReader;
import org.apache.clerezza.triaxrs.util.AcceptHeader;
import org.apache.clerezza.triaxrs.util.CaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.HeaderName;
import org.wymiwyg.wrhapi.Method;
import org.wymiwyg.wrhapi.Request;

public class WebRequestImpl
implements WebRequest {
    private static Logger logger = LoggerFactory.getLogger(WebRequestImpl.class);
    private Request wrhapiRequest;
    private MultivaluedMap<String, String> headers = null;
    private Providers providers;
    private BodyKey bodyKey = null;
    private Object body = null;
    private AcceptHeader acceptHeader = null;

    WebRequestImpl(Request wrhapiRequest, Providers providers) {
        this.wrhapiRequest = wrhapiRequest;
        this.providers = providers;
    }

    @Override
    public Request getWrhapiRequest() {
        return this.wrhapiRequest;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        if (this.headers == null) {
            try {
                this.headers = this.getHeadersFromRequest(this.wrhapiRequest);
            }
            catch (HandlerException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.headers;
    }

    @Override
    public AcceptHeader getAcceptHeader() {
        if (this.acceptHeader == null) {
            List acceptHeaderStrings = (List)this.getHeaders().get("Accept");
            logger.debug("Accept-Header: {}", (Object)acceptHeaderStrings);
            this.acceptHeader = new AcceptHeader(acceptHeaderStrings);
        }
        return this.acceptHeader;
    }

    @Override
    public <T> T getBodyObject(Class<T> type, Type genericType, Annotation[] transformationAnnotation) {
        BodyKey requestBodyKey = new BodyKey(type, genericType, transformationAnnotation);
        if (this.bodyKey != null) {
            if (this.bodyKey.equals(requestBodyKey)) {
                return (T)this.body;
            }
            throw new RuntimeException("Body already returned as something else");
        }
        this.bodyKey = requestBodyKey;
        InputStream inputStream = null;
        try {
            String[] contentTypeHeaders = this.wrhapiRequest.getHeaderValues(HeaderName.CONTENT_TYPE);
            MediaType mediaType = contentTypeHeaders == null || contentTypeHeaders.length == 0 ? MediaType.APPLICATION_OCTET_STREAM_TYPE : MediaType.valueOf(contentTypeHeaders[0]);
            MessageBodyReader<T> reader = this.providers.getMessageBodyReader(type, genericType, transformationAnnotation, mediaType);
            inputStream = Channels.newInputStream(this.wrhapiRequest.getMessageBody().read());
            if (reader == null) {
                reader = new JafMessageBodyReader();
            }
            T result = reader.readFrom(type, genericType, transformationAnnotation, mediaType, this.headers, inputStream);
            this.body = result;
            return result;
        }
        catch (HandlerException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private MultivaluedMap<String, String> getHeadersFromRequest(Request request) throws HandlerException {
        Set names = request.getHeaderNames();
        CaseInsensitiveMap<String> result = new CaseInsensitiveMap<String>();
        if (names == null) {
            return result;
        }
        for (HeaderName headerName : names) {
            String[] headerValues;
            for (String s : headerValues = request.getHeaderValues(headerName)) {
                result.add(headerName.toString(), s);
            }
        }
        return result;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(EntityTag arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date arg0, EntityTag arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMethod() {
        try {
            Method method = this.wrhapiRequest.getMethod();
            if (method != null) {
                return method.toString().substring(8);
            }
            return null;
        }
        catch (HandlerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Variant selectVariant(List<Variant> arg0) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class BodyKey {
        private Annotation[] transformationAnnotation;
        private Type genericType;
        private Class<?> type;

        public BodyKey(Class<?> type, Type genericType, Annotation[] transformationAnnotation) {
            this.type = type;
            this.genericType = genericType;
            this.transformationAnnotation = transformationAnnotation;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BodyKey other = (BodyKey)obj;
            if (!(this.transformationAnnotation == other.transformationAnnotation || this.transformationAnnotation != null && this.transformationAnnotation.equals(other.transformationAnnotation))) {
                return false;
            }
            if (!(this.genericType == other.genericType || this.genericType != null && this.genericType.equals(other.genericType))) {
                return false;
            }
            return this.type == other.type || this.type != null && this.type.equals(other.type);
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + (this.transformationAnnotation != null ? this.transformationAnnotation.hashCode() : 0);
            hash = 89 * hash + (this.genericType != null ? this.genericType.hashCode() : 0);
            hash = 89 * hash + (this.type != null ? this.type.hashCode() : 0);
            return hash;
        }
    }
}

