/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.parameterinjectors;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;

class ConversionUtil {
    ConversionUtil() {
    }

    static <T> T convert(List<String> values, Type type, Convertor<?> ... convertors) throws UnsupportedFieldType {
        ParameterizedType pType;
        Class rawClass;
        if (values == null) {
            return null;
        }
        if (type instanceof ParameterizedType && Collection.class.isAssignableFrom(rawClass = (Class)(pType = (ParameterizedType)type).getRawType())) {
            Class argClass = (Class)pType.getActualTypeArguments()[0];
            if (List.class.isAssignableFrom(rawClass)) {
                if (String.class.isAssignableFrom(argClass)) {
                    return (T)Collections.unmodifiableList(values);
                }
                ArrayList<T> result = new ArrayList<T>();
                for (String val : values) {
                    result.add(ConversionUtil.convert(val, argClass, convertors));
                }
                return (T)result;
            }
            if (Set.class.isAssignableFrom(rawClass)) {
                if (String.class.isAssignableFrom(argClass)) {
                    return (T)Collections.unmodifiableSortedSet(new TreeSet<String>(values));
                }
                TreeSet<T> result = new TreeSet<T>();
                for (String val : values) {
                    result.add(ConversionUtil.convert(val, argClass, convertors));
                }
                return (T)result;
            }
        }
        if (values.size() == 0) {
            return null;
        }
        if (type instanceof Class) {
            return ConversionUtil.convert(values.get(0), (Class)type, convertors);
        }
        throw new IllegalArgumentException("Can't handle type: " + type + " having getClass(): " + type.getClass());
    }

    private static <T> T convert(String value, Class<T> type, Convertor<?> ... convertors) throws UnsupportedFieldType {
        if (value == null) {
            return null;
        }
        for (Convertor<?> convertor : convertors) {
            if (!((ParameterizedType)convertor.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0].equals(type)) continue;
            return (T)convertor.convert(value);
        }
        Constructor<T> stringConstructor = null;
        try {
            if (type.isPrimitive()) {
                return ConversionUtil.getPrimitiveValue(value, type);
            }
            try {
                stringConstructor = type.getConstructor(String.class);
                return stringConstructor.newInstance(value);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method valueOfMethod = type.getMethod("valueOf", String.class);
                    return (T)valueOfMethod.invoke(null, value);
                }
                catch (NoSuchMethodException e2) {
                }
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        throw new UnsupportedFieldType("cannot convert value to " + type);
    }

    private static <T> T getPrimitiveValue(String value, Class<T> type) {
        if (type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(value);
        }
        if (type.equals(Character.TYPE)) {
            return (T)Character.valueOf(value.charAt(0));
        }
        if (type.equals(Short.TYPE)) {
            return (T)Short.valueOf(value);
        }
        if (type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(value);
        }
        if (type.equals(Long.TYPE)) {
            return (T)Long.valueOf(value);
        }
        if (type.equals(Float.TYPE)) {
            return (T)Float.valueOf(value);
        }
        if (type.equals(Double.TYPE)) {
            return (T)Double.valueOf(value);
        }
        throw new RuntimeException(type + " is not a known primitive type");
    }

    static interface Convertor<T> {
        public T convert(String var1);
    }
}

