/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.parameterinjectors;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.headerDelegate.CookieHeaderDelegate;
import org.apache.clerezza.triaxrs.headerDelegate.LocaleProvider;
import org.apache.clerezza.triaxrs.parameterinjectors.ConversionUtil;
import org.apache.clerezza.triaxrs.parameterinjectors.ParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderParameterInjector
implements ParameterInjector<HeaderParam> {
    static final CookieHeaderDelegate cookieProvider = new CookieHeaderDelegate();
    private Logger logger = LoggerFactory.getLogger(HeaderParameterInjector.class);

    @Override
    public <T> T getValue(WebRequest request, Map<String, String> pathParam, Providers providers, Type parameterType, HeaderParam annotation, boolean encodingDisabled, String defaultValue) throws UnsupportedFieldType {
        String headerName = annotation.value();
        List<String> headerValues = (List<String>)request.getHeaders().get(headerName);
        if (headerValues == null && defaultValue != null) {
            headerValues = Collections.singletonList(defaultValue);
        }
        return ConversionUtil.convert(headerValues, parameterType, new ConversionUtil.Convertor<Locale>(){

            @Override
            public Locale convert(String string) {
                try {
                    return new LocaleProvider().fromString(string);
                }
                catch (IllegalArgumentException ex) {
                    HeaderParameterInjector.this.logger.error("Exception {}", (Throwable)ex);
                    return null;
                }
            }
        });
    }
}

