/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.parameterinjectors;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.parameterinjectors.ConversionUtil;
import org.apache.clerezza.triaxrs.parameterinjectors.ParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.apache.clerezza.triaxrs.util.PathSegmentImpl;
import org.apache.clerezza.triaxrs.util.uri.UriEncoder;

public class PathParameterInjector
implements ParameterInjector<PathParam> {
    @Override
    public <T> T getValue(WebRequest request, Map<String, String> pathParam, Providers providers, Type parameterType, PathParam annotation, final boolean encodingDisabled, String defaultValue) throws UnsupportedFieldType {
        String value = pathParam.get(annotation.value());
        ArrayList<String> stringValues = new ArrayList<String>();
        if (value == null || value.equals("") && defaultValue != null) {
            value = defaultValue;
        }
        stringValues.add(value);
        return ConversionUtil.convert(stringValues, parameterType, new ConversionUtil.Convertor<PathSegment>(){

            @Override
            public PathSegment convert(String string) {
                if (string == null) {
                    return null;
                }
                return PathSegmentImpl.parse(string, encodingDisabled);
            }
        }, new ConversionUtil.Convertor<String>(){

            @Override
            public String convert(String string) {
                if (encodingDisabled) {
                    return string;
                }
                return UriEncoder.decodeString(string);
            }
        });
    }
}

