/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.providers.ProviderCriteria;
import org.apache.clerezza.triaxrs.providers.SelectableProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidersImpl
implements Providers {
    private Set<MessageBodyReader<?>> bodyReaders;
    private SelectableProviders<MessageBodyReader<?>> selectableBodyReaders;
    private Set<MessageBodyWriter<?>> bodyWriters;
    private SelectableProviders<MessageBodyWriter<?>> selectableBodyWriters;
    private Set<ExceptionMapper<?>> exceptionMappers;
    private Set<ContextResolver<?>> contextResolvers;
    private Logger logger = LoggerFactory.getLogger(ProvidersImpl.class);

    public ProvidersImpl() {
        this.bodyReaders = new HashSet();
        this.bodyWriters = new HashSet();
        this.exceptionMappers = new HashSet();
        this.contextResolvers = new HashSet();
        this.selectableBodyReaders = this.selectableBodyReaderFromSet(this.bodyReaders);
        this.selectableBodyWriters = this.selectableBodyWritersFromSet(this.bodyWriters);
    }

    public ProvidersImpl(Class<?>[] providerClasses) {
        this.bodyReaders = new HashSet();
        this.bodyWriters = new HashSet();
        this.exceptionMappers = new HashSet();
        this.contextResolvers = new HashSet();
        HashMap<Class, Set<Object>> typeSetMap = new HashMap<Class, Set<Object>>();
        typeSetMap.put(MessageBodyReader.class, this.bodyReaders);
        typeSetMap.put(MessageBodyWriter.class, this.bodyWriters);
        typeSetMap.put(ExceptionMapper.class, this.exceptionMappers);
        typeSetMap.put(ContextResolver.class, this.contextResolvers);
        for (Class<?> providerClass : providerClasses) {
            for (Class supportedClass : typeSetMap.keySet()) {
                if (!supportedClass.isAssignableFrom(providerClass)) continue;
                try {
                    ((Set)typeSetMap.get(supportedClass)).add(providerClass.newInstance());
                }
                catch (InstantiationException ex) {
                    this.logger.error("Exception {}", (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    this.logger.error("Exception {}", (Throwable)ex);
                }
            }
        }
        this.selectableBodyReaders = this.selectableBodyReaderFromSet(this.bodyReaders);
        this.selectableBodyWriters = this.selectableBodyWritersFromSet(this.bodyWriters);
    }

    public ProvidersImpl(Set<MessageBodyReader<?>> bodyReaders, Set<MessageBodyWriter<?>> bodyWriters, Set<ContextResolver<?>> contextResolvers, Set<ExceptionMapper<?>> exceptionMappers) {
        this.bodyReaders = bodyReaders;
        this.bodyWriters = bodyWriters;
        this.selectableBodyReaders = this.selectableBodyReaderFromSet(bodyReaders);
        this.selectableBodyWriters = this.selectableBodyWritersFromSet(bodyWriters);
        this.contextResolvers = contextResolvers;
        this.exceptionMappers = exceptionMappers;
    }

    public void addClass(Class<?> componentClass) {
        try {
            this.addInstance(componentClass.newInstance());
        }
        catch (InstantiationException ex) {
            this.logger.error("Exception {}", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.error("Exception {}", (Throwable)ex);
        }
    }

    public void addInstance(Object component) {
        if (component instanceof MessageBodyWriter) {
            this.bodyWriters.add((MessageBodyWriter)component);
            this.selectableBodyWriters = this.selectableBodyWritersFromSet(this.bodyWriters);
            return;
        }
        if (component instanceof MessageBodyReader) {
            this.bodyReaders.add((MessageBodyReader)component);
            this.selectableBodyReaders = this.selectableBodyReaderFromSet(this.bodyReaders);
            return;
        }
        if (component instanceof ExceptionMapper) {
            this.exceptionMappers.add((ExceptionMapper)component);
            return;
        }
        throw new RuntimeException("unsupported provider component " + component);
    }

    @Override
    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<ContextResolver<?>> getContextResolvers() {
        return this.contextResolvers;
    }

    @Override
    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> clazz) {
        if (!Exception.class.isAssignableFrom(clazz)) {
            return null;
        }
        Class<T> checkedClass = clazz;
        ExceptionMapper exceptionMapper;
        while ((exceptionMapper = this.getExceptionMapperForExactType(checkedClass)) == null) {
            if (checkedClass == Throwable.class) {
                return null;
            }
            checkedClass = checkedClass.getSuperclass();
        }
        return exceptionMapper;
    }

    boolean isEmpty() {
        return this.bodyReaders.isEmpty() && this.bodyWriters.isEmpty() && this.exceptionMappers.isEmpty() && this.contextResolvers.isEmpty();
    }

    void removeInstance(Object component) {
        if (component instanceof MessageBodyWriter) {
            this.bodyWriters.remove((MessageBodyWriter)component);
            this.selectableBodyWriters = this.selectableBodyWritersFromSet(this.bodyWriters);
            return;
        }
        if (component instanceof MessageBodyReader) {
            this.bodyReaders.remove((MessageBodyReader)component);
            this.selectableBodyReaders = this.selectableBodyReaderFromSet(this.bodyReaders);
            return;
        }
        if (component instanceof ExceptionMapper) {
            this.exceptionMappers.remove((ExceptionMapper)component);
            return;
        }
        throw new RuntimeException("unsupported provider component " + component);
    }

    private ExceptionMapper getExceptionMapperForExactType(Class<?> clazz) {
        for (ExceptionMapper<?> exceptionMapper : this.exceptionMappers) {
            for (Type type : exceptionMapper.getClass().getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != ExceptionMapper.class || !parameterizedType.getActualTypeArguments()[0].equals(clazz)) continue;
                return exceptionMapper;
            }
        }
        return null;
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        return this.selectableBodyReaders.selectFor(c, t, as, mediaType);
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        return this.selectableBodyWriters.selectFor(c, t, as, mediaType);
    }

    private SelectableProviders<MessageBodyReader<?>> selectableBodyReaderFromSet(Set<MessageBodyReader<?>> bodyReaders) {
        return new SelectableProviders(bodyReaders, new ProviderCriteria<MessageBodyReader<?>>(){

            @Override
            public boolean isAcceptable(MessageBodyReader<?> messageBodyReader, Class<?> c, Type t, Annotation[] as, MediaType m) {
                return messageBodyReader.isReadable(c, t, as, m);
            }

            @Override
            public String[] getMediaTypeAnnotationValues(MessageBodyReader<?> producer) {
                Consumes consumes = producer.getClass().getAnnotation(Consumes.class);
                if (consumes == null) {
                    return null;
                }
                return consumes.value();
            }
        });
    }

    private SelectableProviders<MessageBodyWriter<?>> selectableBodyWritersFromSet(Set<MessageBodyWriter<?>> bodyWriters) {
        return new SelectableProviders(bodyWriters, new ProviderCriteria<MessageBodyWriter<?>>(){

            @Override
            public boolean isAcceptable(MessageBodyWriter<?> messageBodyWriter, Class<?> c, Type t, Annotation[] as, MediaType m) {
                return messageBodyWriter.isWriteable(c, t, as, m);
            }

            @Override
            public String[] getMediaTypeAnnotationValues(MessageBodyWriter<?> producer) {
                Produces produces = producer.getClass().getAnnotation(Produces.class);
                if (produces == null) {
                    return null;
                }
                return produces.value();
            }
        });
    }
}

