/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.clerezza.triaxrs.providers.BaseMediaType;
import org.apache.clerezza.triaxrs.providers.ProviderCriteria;
import org.apache.clerezza.triaxrs.util.MediaTypeComparator;
import org.apache.clerezza.triaxrs.util.MultivaluedMapImpl;

class SelectableProviders<T> {
    private Set<T> providers;
    private MultivaluedMap<MediaType, T> type2Provider;
    private Map<BaseMediaType, SortedSet<MediaType>> availableProviderTypes;
    private ProviderCriteria<T> tester;

    SelectableProviders(Set<T> producers, ProviderCriteria<T> tester) {
        this.providers = producers;
        this.tester = tester;
        this.createMaps();
    }

    T selectFor(Class<?> c, Type t, Annotation[] as, MediaType mediaType) {
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        BaseMediaType baseType = new BaseMediaType(mediaType.getType(), mediaType.getSubtype());
        while (true) {
            SortedSet<MediaType> typesForBaseType;
            if ((typesForBaseType = this.availableProviderTypes.get(baseType)) != null) {
                for (MediaType availableType : typesForBaseType) {
                    if (!availableType.isCompatible(mediaType)) continue;
                    List entityProviders = (List)this.type2Provider.get(availableType);
                    for (Object entityProvider : entityProviders) {
                        if (!this.tester.isAcceptable(entityProvider, c, t, as, availableType)) continue;
                        return (T)entityProvider;
                    }
                }
            }
            if (baseType.equals(BaseMediaType.WILDCARD_TYPE)) {
                return null;
            }
            this.generalize(baseType);
        }
    }

    private void generalize(BaseMediaType baseType) {
        if (!baseType.getSubtype().equals("*")) {
            baseType.setSubtype("*");
            return;
        }
        baseType.setType("*");
    }

    private void createMaps() {
        this.type2Provider = new MultivaluedMapImpl<MediaType, T>();
        this.availableProviderTypes = new HashMap<BaseMediaType, SortedSet<MediaType>>();
        for (T entityProvider : this.providers) {
            MediaType[] types;
            block3: for (MediaType type : types = this.getSupportedMediaType(entityProvider)) {
                this.type2Provider.add(type, entityProvider);
                BaseMediaType baseType = new BaseMediaType(type.getType(), type.getSubtype());
                while (true) {
                    SortedSet<MediaType> typeForBaseType;
                    if ((typeForBaseType = this.availableProviderTypes.get(baseType)) == null) {
                        typeForBaseType = new TreeSet<MediaType>(new MediaTypeComparator());
                        try {
                            this.availableProviderTypes.put((BaseMediaType)baseType.clone(), typeForBaseType);
                        }
                        catch (CloneNotSupportedException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    typeForBaseType.add(type);
                    if (baseType.equals(BaseMediaType.WILDCARD_TYPE)) continue block3;
                    this.generalize(baseType);
                }
            }
        }
    }

    @Deprecated
    Set<T> getAll() {
        return this.providers;
    }

    private MediaType[] getSupportedMediaType(T provider) {
        MediaType[] result;
        String[] mediaTypeStrings = this.tester.getMediaTypeAnnotationValues(provider);
        if (mediaTypeStrings == null) {
            result = new MediaType[]{MediaType.WILDCARD_TYPE};
        } else {
            result = new MediaType[mediaTypeStrings.length];
            for (int i = 0; i < mediaTypeStrings.length; ++i) {
                result[i] = MediaType.valueOf(mediaTypeStrings[i]);
            }
        }
        return result;
    }
}

