/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.headerDelegate.CookieHeaderDelegate;
import org.apache.clerezza.triaxrs.headerDelegate.LocaleProvider;
import org.apache.clerezza.triaxrs.headerDelegate.MediaTypeHeaderDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeadersImpl
implements HttpHeaders {
    private WebRequest request;
    private Logger logger = LoggerFactory.getLogger(HttpHeadersImpl.class);

    public HttpHeadersImpl(WebRequest request) {
        this.request = request;
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        List languages = (List)this.request.getHeaders().get("Accept-Language");
        LocaleProvider lp = new LocaleProvider();
        if (languages == null) {
            return null;
        }
        for (String language : languages) {
            try {
                locales.add(lp.fromString(language));
            }
            catch (IllegalArgumentException ex) {
                this.logger.error("Exception {}", (Throwable)ex);
            }
        }
        return locales;
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        return this.request.getAcceptHeader().getEntries();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        LinkedHashMap<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
        List cookieStrings = (List)this.request.getHeaders().get("Cookie");
        CookieHeaderDelegate cp = new CookieHeaderDelegate();
        if (cookieStrings == null) {
            return null;
        }
        for (String cookieString : cookieStrings) {
            Cookie cookie = cp.fromString(cookieString);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    @Override
    public Locale getLanguage() {
        List clang = (List)this.request.getHeaders().get("Content-Language");
        Locale locale = null;
        if (clang == null) {
            return null;
        }
        try {
            locale = new LocaleProvider().fromString((String)clang.get(0));
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("Exception {}", (Throwable)ex);
            return null;
        }
        return locale;
    }

    @Override
    public MediaType getMediaType() {
        List mediatype = (List)this.request.getHeaders().get("Content-Type");
        if (mediatype == null) {
            return null;
        }
        return new MediaTypeHeaderDelegate().fromString((String)mediatype.get(0));
    }

    @Override
    public List<String> getRequestHeader(String name) {
        return (List)this.request.getHeaders().get(name);
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.request.getHeaders();
    }
}

