/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageBundle {
    private final ResourceBundle resourceBundle;
    private final String className;

    public MessageBundle(String packageName, String resourceName, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        this.className = packageName + '.' + resourceName;
        this.resourceBundle = ResourceBundle.getBundle(this.className, locale, classLoader);
    }

    public String getMessage(String key) throws MissingResourceException {
        String msg = this.resourceBundle.getString(key);
        if (msg == null) {
            throw new MissingResourceException("Cannot find resource key \"" + key + "\" in base name " + this.className, this.className, key);
        }
        return msg;
    }
}

