/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.clerezza.triaxrs.util.MethodSignature;
import org.wymiwyg.wrhapi.Method;

public class MethodUtil {
    public static Set<java.lang.reflect.Method> filterByHttpMethod(Set<java.lang.reflect.Method> methods, Method httpMethod) {
        HashSet<java.lang.reflect.Method> result = new HashSet<java.lang.reflect.Method>();
        for (java.lang.reflect.Method method : methods) {
            if (!MethodUtil.getHttpMethodAnnotation(method).equals((Object)httpMethod)) continue;
            result.add(method);
        }
        return result;
    }

    private static Method getHttpMethodAnnotation(java.lang.reflect.Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            Method result = MethodUtil.getHttpMethodAnnotation(annotation);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Method getHttpMethodAnnotation(Annotation annotation) {
        HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
        if (httpMethod == null) {
            return null;
        }
        Method wrhapiMethod = Method.get((String)httpMethod.value());
        return wrhapiMethod;
    }

    public static boolean isResourceMethod(java.lang.reflect.Method method) {
        return MethodUtil.getHttpMethodAnnotation(method) != null;
    }

    public static Set<java.lang.reflect.Method> getAnnotatedMethods(Class<?> clazz) {
        Map<MethodSignature, java.lang.reflect.Method> annotatedmethods = MethodUtil.getAnnotatedSuperClassMethods(clazz);
        HashMap<MethodSignature, java.lang.reflect.Method> annotatedinterfacemethods = new HashMap<MethodSignature, java.lang.reflect.Method>();
        for (Class<?> iface : clazz.getInterfaces()) {
            annotatedinterfacemethods.putAll(MethodUtil.getAnnotatedInterfaceMethods(iface));
        }
        for (java.lang.reflect.Method method : annotatedinterfacemethods.values()) {
            MethodSignature signature = new MethodSignature(method);
            if (annotatedmethods.containsKey(signature)) continue;
            annotatedmethods.put(signature, method);
        }
        return new HashSet<java.lang.reflect.Method>(annotatedmethods.values());
    }

    private static Map<MethodSignature, java.lang.reflect.Method> getAnnotatedSuperClassMethods(Class<?> clazz) {
        if (clazz.getSuperclass() == null) {
            return new HashMap<MethodSignature, java.lang.reflect.Method>();
        }
        Map<MethodSignature, java.lang.reflect.Method> annotatedmethods = MethodUtil.getAnnotatedSuperClassMethods(clazz.getSuperclass());
        for (java.lang.reflect.Method method : clazz.getMethods()) {
            if (!MethodUtil.hasJaxRsAnnotation(method)) continue;
            annotatedmethods.put(new MethodSignature(method), method);
        }
        return annotatedmethods;
    }

    private static Map<MethodSignature, java.lang.reflect.Method> getAnnotatedInterfaceMethods(Class<?> clazz) {
        HashMap<MethodSignature, java.lang.reflect.Method> annotatedmethods = new HashMap<MethodSignature, java.lang.reflect.Method>();
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (clazz2 == null) continue;
            annotatedmethods.putAll(MethodUtil.getAnnotatedInterfaceMethods(clazz2));
        }
        for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
            if (!MethodUtil.hasJaxRsAnnotation((java.lang.reflect.Method)genericDeclaration)) continue;
            annotatedmethods.put(new MethodSignature((java.lang.reflect.Method)genericDeclaration), (java.lang.reflect.Method)genericDeclaration);
        }
        return annotatedmethods;
    }

    private static boolean hasJaxRsAnnotation(java.lang.reflect.Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            HttpMethod httpType = annotationType.getAnnotation(HttpMethod.class);
            if (httpType == null && !annotationType.equals(Consumes.class) && !annotationType.equals(Produces.class) && !annotationType.equals(Path.class) && !annotationType.equals(PathParam.class) && !annotationType.equals(QueryParam.class) && !annotationType.equals(FormParam.class) && !annotationType.equals(MatrixParam.class) && !annotationType.equals(CookieParam.class) && !annotationType.equals(HeaderParam.class) && !annotationType.equals(Encoded.class) && !annotationType.equals(DefaultValue.class) && !annotationType.equals(Context.class) && !annotationType.equals(HttpMethod.class)) continue;
            return true;
        }
        return false;
    }
}

