/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.clerezza.triaxrs.util.MultivaluedMapImpl;
import org.apache.clerezza.triaxrs.util.PathSegmentImpl;
import org.apache.clerezza.triaxrs.util.uri.UriEncoder;
import org.wymiwyg.wrhapi.MessageBody;
import org.wymiwyg.wrhapi.util.parameterparser.KeyValuePair;
import org.wymiwyg.wrhapi.util.parameterparser.ParameterValue;
import org.wymiwyg.wrhapi.util.parameterparser.URLEncodedParameterCollection;

public class QueryStringParser {
    public static MultivaluedMap<String, String> getMatrix(String query, boolean encode) {
        List<PathSegment> segments = QueryStringParser.getPathSegments(query, encode);
        if (segments == null || segments.size() == 0) {
            return null;
        }
        PathSegment lastPathSegment = (PathSegment)segments.toArray()[segments.size() - 1];
        return lastPathSegment.getMatrixParameters();
    }

    public static List<String> getParameterValues(String query, boolean encode, String value) {
        if (query == null) {
            return null;
        }
        MultivaluedMap<String, String> allParameters = QueryStringParser.extractPathParameters(query, "&", encode);
        List values = (List)allParameters.get(value);
        return values;
    }

    public static MultivaluedMap<String, String> getFormParameters(MessageBody body, boolean encode) {
        if (body == null) {
            return null;
        }
        MultivaluedMapImpl<String, String> result = new MultivaluedMapImpl<String, String>();
        URLEncodedParameterCollection coll = new URLEncodedParameterCollection(body);
        for (KeyValuePair aVP : coll) {
            result.add(aVP.getKey(), ((ParameterValue)aVP.getValue()).toString());
        }
        return result;
    }

    public static List<PathSegment> getPathSegments(String path, boolean decode) {
        String[] subPaths;
        LinkedList<PathSegment> pathSegments = new LinkedList<PathSegment>();
        if (path == null) {
            return pathSegments;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((subPaths = path.split("/")).length == 0) {
            PathSegmentImpl pathSegment = new PathSegmentImpl("", new MultivaluedMapImpl<String, String>());
            pathSegments.add(pathSegment);
            return pathSegments;
        }
        for (String subPath : subPaths) {
            if (subPath.length() == 0) continue;
            MultivaluedMap<String, String> matrixMap = null;
            int colon = subPath.indexOf(59);
            if (colon != -1) {
                String matrixParameters = subPath.substring(colon + 1);
                subPath = colon == 0 ? "" : subPath.substring(0, colon);
                matrixMap = QueryStringParser.extractPathParameters(matrixParameters, ";", decode);
            }
            if (decode) {
                subPath = UriEncoder.decodeString(subPath);
            }
            PathSegmentImpl pathSegment = new PathSegmentImpl(subPath, matrixMap);
            pathSegments.add(pathSegment);
        }
        return pathSegments;
    }

    public static MultivaluedMap<String, String> extractPathParameters(String parameters, String deliminator, boolean decode) {
        MultivaluedMapImpl<String, String> map = new MultivaluedMapImpl<String, String>();
        if (parameters == null) {
            return map;
        }
        for (String s : parameters.split(deliminator)) {
            String key;
            if (s.length() == 0) continue;
            String[] keyVal = s.split("=");
            String string = key = decode ? UriEncoder.decodeQuery(keyVal[0]) : keyVal[0];
            if (key.length() == 0) continue;
            String val = keyVal.length == 2 ? (decode ? UriEncoder.decodeQuery(keyVal[1]) : keyVal[1]) : "";
            map.add(key, val);
        }
        return map;
    }
}

