/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.lang.ref.SoftReference;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.clerezza.triaxrs.util.SimpleMap;

public class SoftConcurrentMap<K, V>
implements SimpleMap<K, V> {
    private volatile Map<K, SoftReference<V>> map = new WeakHashMap<K, SoftReference<V>>();

    @Override
    public V get(K key) {
        SoftReference<V> softReference = this.map.get(key);
        return softReference != null ? (V)softReference.get() : null;
    }

    @Override
    public synchronized V put(K key, V val) {
        WeakHashMap<K, SoftReference<V>> copyOfMap = new WeakHashMap<K, SoftReference<V>>();
        boolean complete = false;
        while (!complete) {
            try {
                copyOfMap = new WeakHashMap<K, SoftReference<V>>(this.map);
                complete = true;
            }
            catch (ConcurrentModificationException e) {}
        }
        copyOfMap.put(key, new SoftReference<V>(val));
        this.map = copyOfMap;
        return val;
    }

    @Override
    public synchronized void clear() {
        this.map = new WeakHashMap<K, SoftReference<V>>();
    }
}

