/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util.uri;

public final class UriPathNormalizer {
    private UriPathNormalizer() {
    }

    public static String normalize(String path) {
        int lastChar;
        if (path != null && path.indexOf(".") == -1 && path.indexOf("//") == -1) {
            return path;
        }
        boolean wasNormalized = true;
        int numSegments = 0;
        int src = lastChar = path.length() - 1;
        while (src >= 0) {
            int slash = path.lastIndexOf(47, src);
            if (slash != -1) {
                if (slash == src) {
                    if (src != lastChar) {
                        wasNormalized = false;
                    }
                } else {
                    ++numSegments;
                }
            } else {
                ++numSegments;
            }
            src = slash - 1;
        }
        int[] segments = new int[numSegments];
        char[] chars = new char[path.length()];
        path.getChars(0, chars.length, chars, 0);
        numSegments = 0;
        int src2 = 0;
        while (src2 < chars.length) {
            while (src2 < chars.length && chars[src2] == '/') {
                ++src2;
            }
            if (src2 >= chars.length) continue;
            segments[numSegments++] = src2;
            while (src2 < chars.length && chars[src2] != '/') {
                ++src2;
            }
        }
        int DELETED = -1;
        block4: for (int segment = 0; segment < numSegments; ++segment) {
            int src3 = segments[segment];
            if (chars[src3++] != '.') continue;
            if (src3 == chars.length || chars[src3] == '/') {
                segments[segment] = -1;
                wasNormalized = false;
                continue;
            }
            if (chars[src3++] != '.' || src3 != chars.length && chars[src3] != '/') continue;
            for (int toDelete = segment - 1; toDelete >= 0; --toDelete) {
                if (segments[toDelete] == -1) continue;
                if (chars[segments[toDelete]] == '.') continue block4;
                segments[toDelete] = -1;
                segments[segment] = -1;
                wasNormalized = false;
                continue block4;
            }
        }
        if (wasNormalized) {
            return path;
        }
        int dst = chars[0] == '/' ? 1 : 0;
        block6: for (int segment = 0; segment < numSegments; ++segment) {
            int segmentStart = segments[segment];
            if (segmentStart == -1) continue;
            for (int src4 = segmentStart; src4 < chars.length; ++src4) {
                char ch = chars[src4];
                chars[dst++] = ch;
                if (ch == '/') continue block6;
            }
        }
        return new String(chars, 0, dst);
    }
}

