/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.uima.metadatagenerator.mediatype;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.uima.metadatagenerator.mediatype.MediaTypeTextExtractor;
import org.apache.clerezza.uima.metadatagenerator.mediatype.UnsupportedMediaTypeException;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;

public class TikaTextExtractor
implements MediaTypeTextExtractor {
    private Tika tika;
    private TikaConfig config;

    public TikaTextExtractor() {
        try {
            this.config = TikaConfig.getDefaultConfig();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading Tika configuration.", e);
        }
        this.tika = new Tika(this.config);
    }

    public TikaTextExtractor(String tikaConfigPath) {
        InputStream inputStream = this.getResourceAsStream(tikaConfigPath);
        try {
            this.config = new TikaConfig(inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading Tika configuration.", e);
        }
        this.tika = new Tika(this.config);
    }

    @Override
    public boolean supports(MediaType mediaType) {
        return this.tika.detect(mediaType.getType()) != null;
    }

    @Override
    public String extract(byte[] bytes) throws UnsupportedMediaTypeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String mimeType = null;
        try {
            mimeType = this.tika.detect((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while detecting mime type", e);
        }
        if (this.tika.detect(mimeType) == null) {
            throw new UnsupportedMediaTypeException(String.format("[%s] mime type is not supported", mimeType));
        }
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", mimeType);
        Reader reader = null;
        try {
            reader = this.tika.parse((InputStream)inputStream, metadata);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while parsing the provided input");
        }
        BufferedReader in = new BufferedReader(reader);
        String result = null;
        try {
            String line = in.readLine();
            while (line != null) {
                result = line;
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while parsing the provided input");
        }
        return result;
    }

    private InputStream getResourceAsStream(String tikaConfigFile) {
        InputStream result = TikaTextExtractor.class.getResourceAsStream(tikaConfigFile);
        if (result == null && (result = TikaTextExtractor.class.getClassLoader().getResourceAsStream(tikaConfigFile)) == null) {
            result = ClassLoader.getSystemResourceAsStream(tikaConfigFile);
        }
        return result;
    }
}

