/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.acting.modular.DatabaseAction;
import org.apache.cocoon.components.modules.database.AutoIncrementModule;
import org.apache.cocoon.util.HashMap;

public class DatabaseAddAction
extends DatabaseAction {
    protected int processRow(Map objectModel, Connection conn, PreparedStatement statement, String outputMode, Configuration table, DatabaseAction.CacheHelper queryData, Object[][] columnValues, int rowIndex, Map results) throws SQLException, ConfigurationException, Exception {
        int currentIndex = 1;
        for (int i = 0; i < queryData.columns.length; ++i) {
            DatabaseAction.Column col = queryData.columns[i];
            if (col.isAutoIncrement && col.isKey) {
                currentIndex += this.setKeyAuto(table, col, currentIndex, rowIndex, conn, statement, objectModel, outputMode, results);
                continue;
            }
            this.setOutput(objectModel, outputMode, results, table, col.columnConf, rowIndex, columnValues[i][col.isSet ? rowIndex : 0]);
            this.setColumn(statement, currentIndex, col.columnConf, columnValues[i][col.isSet ? rowIndex : 0]);
            ++currentIndex;
        }
        int rowCount = statement.executeUpdate();
        for (int i = 0; i < queryData.columns.length; ++i) {
            if (!queryData.columns[i].isAutoIncrement || !queryData.columns[i].isKey) continue;
            this.storeKeyValue(table, queryData.columns[i], rowIndex, conn, statement, objectModel, outputMode, results);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setKeyAuto(Configuration table, DatabaseAction.Column column, int currentIndex, int rowIndex, Connection conn, PreparedStatement statement, Map objectModel, String outputMode, Map results) throws ConfigurationException, SQLException, Exception {
        int columnCount;
        block9: {
            ServiceSelector autoincrSelector;
            block10: {
                columnCount = 0;
                autoincrSelector = null;
                AutoIncrementModule autoincr = null;
                try {
                    autoincrSelector = (ServiceSelector)this.manager.lookup(DATABASE_MODULE_SELECTOR);
                    if (column.mode != null && autoincrSelector != null && autoincrSelector.isSelectable((Object)column.mode)) {
                        autoincr = (AutoIncrementModule)autoincrSelector.select((Object)column.mode);
                    }
                    if (autoincr.includeInQuery()) {
                        if (autoincr.includeAsValue()) {
                            Object value = autoincr.getPreValue(table, column.columnConf, column.modeConf, conn, objectModel);
                            this.setColumn(objectModel, outputMode, results, table, column.columnConf, rowIndex, value, statement, currentIndex);
                            columnCount = 1;
                        }
                    } else if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Automatically setting key");
                    }
                    Object var15_14 = null;
                    if (autoincrSelector == null) break block9;
                    if (autoincr == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    if (autoincrSelector != null) {
                        if (autoincr != null) {
                            autoincrSelector.release((Object)autoincr);
                        }
                        this.manager.release((Object)autoincrSelector);
                    }
                    throw throwable;
                }
                autoincrSelector.release((Object)autoincr);
            }
            this.manager.release((Object)autoincrSelector);
            {
            }
        }
        return columnCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeKeyValue(Configuration tableConf, DatabaseAction.Column key, int rowIndex, Connection conn, Statement statement, Map objectModel, String outputMode, Map results) throws SQLException, ConfigurationException, ServiceException {
        block6: {
            ServiceSelector autoincrSelector;
            block7: {
                autoincrSelector = null;
                AutoIncrementModule autoincr = null;
                try {
                    autoincrSelector = (ServiceSelector)this.manager.lookup(DATABASE_MODULE_SELECTOR);
                    if (key.mode != null && autoincrSelector != null && autoincrSelector.isSelectable((Object)key.mode)) {
                        autoincr = (AutoIncrementModule)autoincrSelector.select((Object)key.mode);
                    }
                    if (!autoincr.includeAsValue()) {
                        Object value = autoincr.getPostValue(tableConf, key.columnConf, key.modeConf, conn, statement, objectModel);
                        this.setOutput(objectModel, outputMode, results, tableConf, key.columnConf, rowIndex, value);
                    }
                    Object var13_12 = null;
                    if (autoincrSelector == null) break block6;
                    if (autoincr == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (autoincrSelector != null) {
                        if (autoincr != null) {
                            autoincrSelector.release((Object)autoincr);
                        }
                        this.manager.release((Object)autoincrSelector);
                    }
                    throw throwable;
                }
                autoincrSelector.release((Object)autoincr);
            }
            this.manager.release((Object)autoincrSelector);
            {
            }
        }
    }

    protected String selectMode(boolean isAutoIncrement, Map modes) {
        if (isAutoIncrement) {
            return (String)modes.get(MODE_AUTOINCR);
        }
        return (String)modes.get(MODE_OTHERS);
    }

    protected boolean honourAutoIncrement() {
        return true;
    }

    protected Object[][] getColumnValues(Configuration tableConf, DatabaseAction.CacheHelper queryData, Map objectModel) throws ConfigurationException, ServiceException {
        Object[][] columnValues = new Object[queryData.columns.length][];
        for (int i = 0; i < queryData.columns.length; ++i) {
            columnValues[i] = this.getColumnValue(tableConf, queryData.columns[i], objectModel);
        }
        return columnValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseAction.CacheHelper getQuery(Configuration table, Map modeTypes, Map defaultModeNames) throws ConfigurationException, ServiceException {
        DatabaseAction.LookUpKey lookUpKey = new DatabaseAction.LookUpKey(table, modeTypes);
        DatabaseAction.CacheHelper queryData = null;
        HashMap hashMap = this.cachedQueryData;
        synchronized (hashMap) {
            queryData = (DatabaseAction.CacheHelper)this.cachedQueryData.get((Object)lookUpKey);
            if (queryData == null) {
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                queryData = new DatabaseAction.CacheHelper(keys.length, keys.length + values.length);
                this.fillModes(keys, true, defaultModeNames, modeTypes, queryData);
                this.fillModes(values, false, defaultModeNames, modeTypes, queryData);
                StringBuffer queryBuffer = new StringBuffer("INSERT INTO ");
                StringBuffer valueBuffer = new StringBuffer(") VALUES (");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" (");
                int actualColumns = 0;
                for (int i = 0; i < queryData.columns.length; ++i) {
                    if (actualColumns > 0) {
                        queryBuffer.append(", ");
                        valueBuffer.append(", ");
                    }
                    if (queryData.columns[i].isKey && queryData.columns[i].isAutoIncrement) {
                        ServiceSelector autoincrSelector;
                        block18: {
                            Object var16_15;
                            autoincrSelector = null;
                            AutoIncrementModule autoincr = null;
                            try {
                                autoincrSelector = (ServiceSelector)this.manager.lookup(DATABASE_MODULE_SELECTOR);
                                if (queryData.columns[i].mode != null && autoincrSelector != null && autoincrSelector.isSelectable((Object)queryData.columns[i].mode)) {
                                    autoincr = (AutoIncrementModule)autoincrSelector.select((Object)queryData.columns[i].mode);
                                    if (autoincr.includeInQuery()) {
                                        ++actualColumns;
                                        queryBuffer.append(queryData.columns[i].columnConf.getAttribute("name"));
                                        if (autoincr.includeAsValue()) {
                                            valueBuffer.append("?");
                                        } else {
                                            valueBuffer.append(autoincr.getSubquery(table, queryData.columns[i].columnConf, queryData.columns[i].modeConf));
                                        }
                                    }
                                } else {
                                    if (this.getLogger().isErrorEnabled()) {
                                        this.getLogger().error("Could not find mode description " + queryData.columns[i].mode + " for column #" + i);
                                    }
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("Column data " + queryData.columns[i]);
                                    }
                                    throw new ConfigurationException("Could not find mode description " + queryData.columns[i].mode + " for column " + i);
                                }
                                var16_15 = null;
                                if (autoincrSelector == null) continue;
                                if (autoincr == null) break block18;
                            }
                            catch (Throwable throwable) {
                                var16_15 = null;
                                if (autoincrSelector != null) {
                                    if (autoincr != null) {
                                        autoincrSelector.release(autoincr);
                                    }
                                    this.manager.release((Object)autoincrSelector);
                                }
                                throw throwable;
                            }
                            autoincrSelector.release((Object)autoincr);
                        }
                        this.manager.release((Object)autoincrSelector);
                        {
                            continue;
                        }
                    }
                    ++actualColumns;
                    queryBuffer.append(queryData.columns[i].columnConf.getAttribute("name"));
                    valueBuffer.append("?");
                }
                valueBuffer.append(")");
                queryBuffer.append(valueBuffer);
                queryData.queryString = queryBuffer.toString();
                this.cachedQueryData.put((Object)lookUpKey, (Object)queryData);
            }
        }
        return queryData;
    }
}

