/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.servletservice.DynamicProxyRequestHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DispatcherServlet
extends HttpServlet {
    private static final String MOUNT_PATH = "mountPath";
    private Map mountableServlets = new HashMap();
    private ListableBeanFactory beanFactory;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void init() throws ServletException {
        this.beanFactory = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.logger.info((Object)"DispatcherServlet is initializing");
        Map servlets = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, (Class)Servlet.class);
        Iterator i = servlets.values().iterator();
        while (i.hasNext()) {
            Servlet servlet = (Servlet)i.next();
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)servlet);
            if (!wrapper.isReadableProperty(MOUNT_PATH)) continue;
            String mountPath = (String)wrapper.getPropertyValue(MOUNT_PATH);
            this.logger.debug((Object)("DispatcherServlet: initializing servlet " + servlet + " at " + mountPath));
            this.mountableServlets.put(mountPath, servlet);
        }
        this.log("Block dispatcher was initialized successfully.");
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        path = path == null ? "" : path;
        int index = path.length();
        Servlet servlet = null;
        while (servlet == null && index != -1) {
            path = path.substring(0, index);
            servlet = (Servlet)this.mountableServlets.get(path);
            index = path.lastIndexOf(47);
        }
        if (servlet == null) {
            throw new ServletException("No block for " + req.getPathInfo());
        }
        HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(req.getClass().getClassLoader(), this.getInterfaces(req.getClass()), (InvocationHandler)new DynamicProxyRequestHandler(req, path));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherServlet: service servlet=" + servlet + " mountPath=" + path + " servletPath=" + request.getServletPath() + " pathInfo=" + request.getPathInfo()));
        }
        servlet.service((ServletRequest)request, (ServletResponse)res);
    }

    private void getInterfaces(Set interfaces, Class clazz) {
        Class<?>[] clazzInterfaces = clazz.getInterfaces();
        for (int i = 0; i < clazzInterfaces.length; ++i) {
            this.getInterfaces(interfaces, clazzInterfaces[i]);
        }
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            this.getInterfaces(interfaces, superclazz);
        }
        interfaces.addAll(Arrays.asList(clazzInterfaces));
    }

    private Class[] getInterfaces(Class clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        this.getInterfaces(interfaces, clazz);
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

