/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.util.BlockCallHttpServletRequest;
import org.apache.cocoon.servletservice.util.BlockCallHttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ServletConnection {
    private BlockCallHttpServletRequest request;
    private BlockCallHttpServletResponse response;
    private String blockName;
    private final ServletContext context;
    private String systemId;
    private Log logger = LogFactory.getLog(this.getClass());

    public ServletConnection(String url) throws MalformedURLException {
        URI blockURI = null;
        try {
            blockURI = this.parseBlockURI(new URI(url.toString()));
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Malformed URI in block source " + e.getMessage());
        }
        this.context = "super".equals(this.blockName) ? CallStackHelper.getCurrentServletContext() : CallStackHelper.getBaseServletContext();
        if (this.context == null) {
            throw new MalformedURLException("Must be used in a block context " + url);
        }
        this.request = new BlockCallHttpServletRequest(blockURI);
        this.response = new BlockCallHttpServletResponse();
    }

    public void connect() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException, ServletException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.response.setOutputStream(os);
        RequestDispatcher dispatcher = null;
        try {
            dispatcher = this.blockName == null ? this.context.getRequestDispatcher(this.systemId) : this.context.getNamedDispatcher(this.blockName);
            if (dispatcher == null) {
                throw new ServletException("No dispatcher for " + this.systemId);
            }
            dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
            this.response.flushBuffer();
            byte[] out = os.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out);
            return byteArrayInputStream;
        }
        finally {
            os.close();
        }
    }

    private URI parseBlockURI(URI uri) throws URISyntaxException {
        if (!uri.isAbsolute()) {
            throw new URISyntaxException(uri.toString(), "Only absolute URIs are allowed for the block protocol.");
        }
        String scheme = uri.getScheme();
        this.logger.debug((Object)("ServletSource: resolving " + uri.toString() + " with scheme " + uri.getScheme() + " and ssp " + uri.getRawSchemeSpecificPart()));
        uri = new URI(uri.getRawSchemeSpecificPart());
        this.logger.debug((Object)("ServletSource: resolved to " + uri.toString()));
        this.blockName = uri.getScheme();
        String path = uri.getPath();
        String queryString = uri.getQuery();
        String ssp = new URI(this.blockName, null, path, queryString, null).toString();
        this.systemId = new URI(scheme, ssp, null).toString();
        return new URI(scheme, null, path, queryString, null);
    }
}

