/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.servletservice.ServletServiceContext;
import org.apache.cocoon.servletservice.ServletServiceContextAware;
import org.apache.cocoon.servletservice.util.ServletConfigurationWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletService
extends HttpServlet
implements ApplicationContextAware,
ServletContextAware,
BeanNameAware,
InitializingBean,
DisposableBean,
ServletServiceContextAware {
    private ServletServiceContext servletServiceContext = new ServletServiceContext();
    private String embeddedServletClass;
    private Servlet embeddedServlet;
    private ServletContext servletContext;
    private String beanName;
    private ApplicationContext parentContainer;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletServiceContext.setServletContext(servletConfig.getServletContext());
        if (this.parentContainer == null) {
            this.parentContainer = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletConfig.getServletContext());
        }
        GenericWebApplicationContext container = new GenericWebApplicationContext();
        container.setParent(this.parentContainer);
        container.setServletContext((ServletContext)this.servletServiceContext);
        container.refresh();
        this.servletServiceContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, container);
        ServletConfigurationWrapper blockServletConfig = new ServletConfigurationWrapper(servletConfig, this.servletServiceContext){

            public String getInitParameter(String name) {
                return super.getServletContext().getInitParameter(name);
            }

            public Enumeration getInitParameterNames() {
                return super.getServletContext().getInitParameterNames();
            }
        };
        this.embeddedServlet = this.createEmbeddedServlet(this.embeddedServletClass, blockServletConfig);
        this.embeddedServlet.init((ServletConfig)blockServletConfig);
        this.servletServiceContext.setServlet(this.embeddedServlet);
    }

    protected Servlet createEmbeddedServlet(String embeddedServletClassName, ServletConfig servletConfig) throws ServletException {
        try {
            return (Servlet)this.getClass().getClassLoader().loadClass(embeddedServletClassName).newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Loading class for embedded servlet failed " + embeddedServletClassName, (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.servletServiceContext.getRequestDispatcher(request.getPathInfo());
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        this.embeddedServlet.destroy();
        super.destroy();
    }

    public ServletContext getServletServiceContext() {
        return this.servletServiceContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContainer = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setMountPath(String mountPath) {
        this.servletServiceContext.setMountPath(mountPath);
    }

    public String getMountPath() {
        return this.servletServiceContext.getMountPath();
    }

    public void setBlockContextURL(String blockContextURL) {
        this.servletServiceContext.setContextPath(blockContextURL);
    }

    public void setServletClass(String servletClass) {
        this.embeddedServletClass = servletClass;
    }

    public void setProperties(Map properties) {
        this.servletServiceContext.setInitParams(properties);
    }

    public void setConnections(Map connections) {
        this.servletServiceContext.setConnections(connections);
    }

    public void afterPropertiesSet() throws Exception {
        ServletConfig servletConfig = new ServletConfig(){

            public String getInitParameter(String parameter) {
                return ServletService.this.servletContext.getInitParameter(parameter);
            }

            public Enumeration getInitParameterNames() {
                return ServletService.this.servletContext.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return ServletService.this.servletContext;
            }

            public String getServletName() {
                return ServletService.this.beanName;
            }
        };
        this.init(servletConfig);
    }
}

