/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.spring;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.cocoon.servletservice.Mountable;
import org.apache.cocoon.servletservice.ServletServiceContext;
import org.apache.cocoon.servletservice.ServletServiceContextAware;
import org.springframework.aop.Advisor;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletFactoryBean
implements FactoryBean,
ApplicationContextAware,
ServletContextAware,
BeanNameAware {
    private ApplicationContext parentContainer;
    private ServletContext servletContext;
    private String beanName;
    private Servlet embeddedServlet;
    private String mountPath;
    private String contextPath;
    private Map initParams;
    private Map contextParams;
    private Map connections;
    private ServletServiceContext servletServiceContext;
    static /* synthetic */ Class class$org$apache$cocoon$servletservice$Mountable;
    static /* synthetic */ Class class$org$apache$cocoon$servletservice$ServletServiceContextAware;

    public void init() throws Exception {
        this.servletServiceContext = new ServletServiceContext();
        this.servletServiceContext.setServletContext(this.servletContext);
        this.servletServiceContext.setMountPath(this.mountPath);
        this.servletServiceContext.setContextPath(this.contextPath);
        this.servletServiceContext.setInitParams(this.initParams);
        this.servletServiceContext.setAttributes(this.contextParams);
        this.servletServiceContext.setConnections(this.connections);
        if (this.parentContainer == null) {
            this.parentContainer = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
        }
        GenericWebApplicationContext container = new GenericWebApplicationContext();
        container.setParent(this.parentContainer);
        container.setServletContext((ServletContext)this.servletServiceContext);
        container.refresh();
        this.servletServiceContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, container);
        ServletConfig blockServletConfig = new ServletConfig(){

            public String getInitParameter(String name) {
                return ServletFactoryBean.this.servletServiceContext.getInitParameter(name);
            }

            public Enumeration getInitParameterNames() {
                return ServletFactoryBean.this.servletServiceContext.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return ServletFactoryBean.this.servletServiceContext;
            }

            public String getServletName() {
                return ServletFactoryBean.this.beanName;
            }
        };
        this.embeddedServlet.init(blockServletConfig);
        this.servletServiceContext.setServlet(this.embeddedServlet);
    }

    public void destroy() {
        this.embeddedServlet.destroy();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContainer = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setEmbeddedServlet(Servlet embeddedServlet) {
        this.embeddedServlet = embeddedServlet;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setInitParams(Map initParams) {
        this.initParams = initParams;
    }

    public void setContextParams(Map contextParams) {
        this.contextParams = contextParams;
    }

    public void setConnections(Map connections) {
        this.connections = connections;
    }

    public Object getObject() throws Exception {
        ProxyFactory proxyFactory = new ProxyFactory((Object)this.embeddedServlet);
        proxyFactory.addAdvice((Advice)new ServiceInterceptor());
        if (this.mountPath != null) {
            proxyFactory.addAdvisor((Advisor)new MountableMixinAdvisor());
        }
        proxyFactory.addAdvisor((Advisor)new ServletServiceContextMixinAdvisor());
        return proxyFactory.getProxy();
    }

    public Class getObjectType() {
        return this.embeddedServlet.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    private class ServletServiceContextMixinAdvisor
    extends DefaultIntroductionAdvisor {
        public ServletServiceContextMixinAdvisor() {
            super((DynamicIntroductionAdvice)new ServletServiceContextMixin(), class$org$apache$cocoon$servletservice$ServletServiceContextAware == null ? (class$org$apache$cocoon$servletservice$ServletServiceContextAware = ServletFactoryBean.class$("org.apache.cocoon.servletservice.ServletServiceContextAware")) : class$org$apache$cocoon$servletservice$ServletServiceContextAware);
        }
    }

    private class ServletServiceContextMixin
    extends DelegatingIntroductionInterceptor
    implements ServletServiceContextAware {
        private ServletServiceContextMixin() {
        }

        public ServletContext getServletServiceContext() {
            return ServletFactoryBean.this.servletServiceContext;
        }
    }

    private class MountableMixinAdvisor
    extends DefaultIntroductionAdvisor {
        public MountableMixinAdvisor() {
            super((DynamicIntroductionAdvice)new MountableMixin(), class$org$apache$cocoon$servletservice$Mountable == null ? (class$org$apache$cocoon$servletservice$Mountable = ServletFactoryBean.class$("org.apache.cocoon.servletservice.Mountable")) : class$org$apache$cocoon$servletservice$Mountable);
        }
    }

    private class MountableMixin
    extends DelegatingIntroductionInterceptor
    implements Mountable {
        private MountableMixin() {
        }

        public String getMountPath() {
            return ServletFactoryBean.this.mountPath;
        }
    }

    private class ServiceInterceptor
    implements MethodInterceptor {
        private ServiceInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if ("service".equals(invocation.getMethod().getName())) {
                Object[] arguments = invocation.getArguments();
                HttpServletRequest request = (HttpServletRequest)arguments[0];
                HttpServletResponse response = (HttpServletResponse)arguments[1];
                RequestDispatcher dispatcher = ServletFactoryBean.this.servletServiceContext.getRequestDispatcher(request.getPathInfo());
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return null;
            }
            return invocation.proceed();
        }
    }
}

