/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.callstack;

import java.util.Stack;
import org.apache.cocoon.callstack.CallFrame;

public class CallStack {
    private static final ThreadLocal callStack = new ThreadLocal();

    public static void enter() {
        Stack<CallFrame> stack = (Stack<CallFrame>)callStack.get();
        if (stack == null) {
            stack = new Stack<CallFrame>();
            callStack.set(stack);
        }
        CallFrame info = new CallFrame();
        stack.push(info);
    }

    public static void leave() {
        Stack stack = (Stack)callStack.get();
        CallFrame info = (CallFrame)stack.pop();
        info.executeDestructionCallbacks();
    }

    public static CallFrame getCurrentFrame() {
        Stack stack = (Stack)callStack.get();
        if (stack != null && !stack.isEmpty()) {
            return (CallFrame)stack.peek();
        }
        return null;
    }

    public static int size() {
        Stack stack = (Stack)callStack.get();
        return stack != null ? stack.size() : 0;
    }

    public static CallFrame frameAt(int i) {
        Stack stack = (Stack)callStack.get();
        return stack != null ? stack.elementAt(i) : null;
    }
}

