/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.callstack.environment.CallFrameHelper;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.util.BlockCallHttpServletRequest;
import org.apache.cocoon.servletservice.util.BlockCallHttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ServletConnection {
    private final Log logger = LogFactory.getLog(this.getClass());
    private BlockCallHttpServletRequest request;
    private BlockCallHttpServletResponse response;
    private String blockName;
    private final ServletContext context;
    private String systemId;
    private boolean connected;
    private ByteArrayOutputStream requestBody;
    private InputStream responseBody;

    public ServletConnection(String url) throws MalformedURLException {
        URI blockURI;
        try {
            blockURI = this.parseBlockURI(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Malformed URI in block source " + e.getMessage());
        }
        this.context = "super".equals(this.blockName) ? CallStackHelper.getCurrentServletContext() : CallStackHelper.getBaseServletContext();
        if (this.context == null) {
            throw new MalformedURLException("Must be used in a block context " + url);
        }
        this.request = new BlockCallHttpServletRequest(blockURI, CallFrameHelper.getRequest());
        this.response = new BlockCallHttpServletResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, ServletException {
        if (this.connected) {
            return;
        }
        if (this.requestBody != null) {
            this.request.setMethod("POST");
            this.request.setInputStream(new ByteArrayInputStream(this.requestBody.toByteArray()));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.response.setOutputStream(os);
        try {
            RequestDispatcher dispatcher = this.blockName == null ? this.context.getRequestDispatcher(this.systemId) : this.context.getNamedDispatcher(this.blockName);
            if (dispatcher == null) {
                throw new ServletException("No dispatcher for " + this.systemId);
            }
            dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
            this.response.flushBuffer();
            this.responseBody = new ByteArrayInputStream(os.toByteArray());
        }
        finally {
            os.close();
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException, ServletException {
        this.connect();
        return this.responseBody;
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.request.setDateHeader("If-Modified-Since", ifmodifiedsince);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("Last-Modified", 0L);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public long getHeaderFieldDate(String name, long Default) {
        try {
            return this.response.getDateHeader(name);
        }
        catch (Exception e) {
            return Default;
        }
    }

    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (Exception e) {
            return null;
        }
        return this.response.getHeader(name);
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (ServletException e) {
                throw new IOException("Could not get response status code");
            }
        }
        return this.response.getStatus();
    }

    public OutputStream getOutputStream() throws IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException("You cannot write to the connection already connected.");
        }
        if (this.requestBody == null) {
            this.requestBody = new ByteArrayOutputStream();
        }
        return this.requestBody;
    }

    private URI parseBlockURI(URI uri) throws URISyntaxException {
        if (!uri.isAbsolute()) {
            throw new URISyntaxException(uri.toString(), "Only absolute URIs are allowed for the block protocol.");
        }
        String scheme = uri.getScheme();
        this.logger.debug((Object)("ServletSource: resolving " + uri + " with scheme " + uri.getScheme() + " and ssp " + uri.getRawSchemeSpecificPart()));
        uri = new URI(uri.getRawSchemeSpecificPart());
        this.logger.debug((Object)("ServletSource: resolved to " + uri));
        this.blockName = uri.getScheme();
        String path = uri.getPath();
        String queryString = uri.getQuery();
        String ssp = new URI(this.blockName, null, path, queryString, null).toString();
        this.systemId = new URI(scheme, ssp, null).toString();
        return new URI(scheme, null, path, queryString, null);
    }
}

