/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.cocoon.servletservice.Absolutizable;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.util.ServletContextWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletServiceContext
extends ServletContextWrapper
implements Absolutizable {
    public static final String SUPER = "super";
    private final Log logger = LogFactory.getLog((Class)ServletServiceContext.class);
    private Map attributes = new Hashtable();
    private Servlet servlet;
    private String mountPath;
    private String contextPath;
    private Map properties;
    private Map connections;

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        return value != null ? value : super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttributes(Map map) {
        if (map != null) {
            this.attributes = map;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String path) throws MalformedURLException {
        block8: {
            if (!this.contextPath.startsWith("file:") && !this.contextPath.startsWith("/") && this.contextPath.indexOf(58) != -1) {
                SourceResolver resolver = null;
                Source source = null;
                try {
                    WebApplicationContext factory = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this);
                    resolver = (SourceResolver)factory.getBean(SourceResolver.ROLE);
                    source = resolver.resolveURI(this.contextPath);
                    this.contextPath = source.getURI();
                    if (resolver == null) break block8;
                }
                catch (IOException e) {
                    try {
                        throw new MalformedURLException("Could not resolve " + this.contextPath);
                    }
                    catch (Throwable throwable) {
                        if (resolver != null) {
                            resolver.release(source);
                        }
                        throw throwable;
                    }
                }
                resolver.release(source);
            }
        }
        if (this.contextPath.startsWith("file:")) {
            return new URL("file", null, this.contextPath.substring("file:".length()) + path);
        }
        if (this.contextPath.length() != 0 && this.contextPath.charAt(0) != '/') {
            throw new MalformedURLException("The contextPath must be empty or start with '/' " + this.contextPath);
        }
        return super.getResource(this.contextPath + path);
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getInitParameter(String name) {
        ServletContext superContext;
        if (this.properties == null) {
            return null;
        }
        String value = (String)this.properties.get(name);
        if (value == null && (superContext = this.getNamedContext(SUPER)) != null) {
            value = superContext.getInitParameter(name);
        }
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    public Enumeration getInitParameterNames() {
        Vector<Object> names = new Vector<Object>();
        Enumeration enumeration = super.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            names.add(enumeration.nextElement());
        }
        ServletContext superContext = this.getNamedContext(SUPER);
        if (superContext != null) {
            enumeration = superContext.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                names.add(enumeration.nextElement());
            }
        }
        if (this.properties != null) {
            names.addAll(this.properties.keySet());
        }
        return names.elements();
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    private Collection getDirectoryList(File file, String pathPrefix) {
        ArrayList<String> filenames = new ArrayList<String>();
        if (!file.isDirectory()) {
            filenames.add("/" + file.toString().substring(pathPrefix.length() - 1));
            return filenames;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File subfile = files[i];
            filenames.addAll(this.getDirectoryList(subfile, pathPrefix));
        }
        return filenames;
    }

    public Set getResourcePaths(String path) {
        String pathPrefix = this.contextPath.startsWith("file:") ? this.contextPath.substring("file:".length()) : this.contextPath;
        path = pathPrefix + path;
        if (path == null) {
            return Collections.EMPTY_SET;
        }
        File file = new File(path);
        if (!file.exists()) {
            return Collections.EMPTY_SET;
        }
        HashSet set = new HashSet();
        set.addAll(this.getDirectoryList(file, pathPrefix));
        return set;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        PathDispatcher dispatcher = new PathDispatcher(path);
        return dispatcher.exists() ? dispatcher : null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        NamedDispatcher dispatcher = new NamedDispatcher(name);
        return dispatcher.exists() ? dispatcher : null;
    }

    public String getServerInfo() {
        return null;
    }

    public String getServletContextName() {
        return null;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public URI absolutizeURI(URI uri) throws URISyntaxException {
        ServletServiceContext servletServiceContext;
        String servletServiceName = uri.getScheme();
        if (servletServiceName == null) {
            servletServiceContext = this;
        } else {
            servletServiceContext = (ServletServiceContext)this.getNamedContext(servletServiceName);
            if (servletServiceContext == null) {
                throw new URISyntaxException(uri.toString(), "Unknown servlet service name");
            }
        }
        String mountPath = servletServiceContext.getMountPath();
        if (mountPath == null) {
            throw new URISyntaxException(uri.toString(), "No mount point for this URI");
        }
        if (mountPath.endsWith("/")) {
            mountPath = mountPath.substring(0, mountPath.length() - 1);
        }
        String absoluteURI = mountPath + uri.getSchemeSpecificPart();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Resolving " + uri.toString() + " to " + absoluteURI));
        }
        return new URI(absoluteURI);
    }

    public ServletContext getNamedContext(String name) {
        Servlet _super;
        if (this.connections == null) {
            return null;
        }
        Servlet servlet = (Servlet)this.connections.get(name);
        if (servlet == null && !name.equals(SUPER) && (_super = (Servlet)this.connections.get(SUPER)) != null) {
            ServletContext c = _super.getServletConfig().getServletContext();
            if (c instanceof ServletServiceContext) {
                return ((ServletServiceContext)c).getNamedContext(name);
            }
            return null;
        }
        return servlet != null ? servlet.getServletConfig().getServletContext() : null;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setInitParams(Map properties) {
        this.properties = properties;
    }

    public void setConnections(Map connections) {
        this.connections = connections;
    }

    private static class StatusRetrievableWrappedResponse
    extends HttpServletResponseWrapper {
        private int status;

        public StatusRetrievableWrappedResponse(HttpServletResponse wrapped) {
            super(wrapped);
        }

        public void setStatus(int sc, String sm) {
            this.status = sc;
            super.setStatus(sc, sm);
        }

        public void setStatus(int sc) {
            this.status = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.status;
        }

        public void sendError(int errorCode) throws IOException {
            this.status = errorCode;
            super.sendError(errorCode);
        }

        public void sendError(int errorCode, String errorMessage) throws IOException {
            this.status = errorCode;
            super.sendError(errorCode, errorMessage);
        }
    }

    private class PathDispatcher
    implements RequestDispatcher {
        private PathDispatcher(String path) {
        }

        private boolean exists() {
            return ServletServiceContext.this.servlet != null;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.forward(request, response, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forward(ServletRequest request, ServletResponse response, boolean superCall) throws ServletException, IOException {
            block8: {
                try {
                    StatusRetrievableWrappedResponse wrappedResponse = new StatusRetrievableWrappedResponse((HttpServletResponse)response);
                    wrappedResponse.setStatus(200);
                    if (!superCall) {
                        CallStackHelper.enterServlet(ServletServiceContext.this, (HttpServletRequest)request, (HttpServletResponse)wrappedResponse);
                    } else {
                        CallStackHelper.enterSuperServlet(ServletServiceContext.this, (HttpServletRequest)request, (HttpServletResponse)wrappedResponse);
                    }
                    ServletException se = null;
                    try {
                        ServletServiceContext.this.servlet.service(request, (ServletResponse)wrappedResponse);
                    }
                    catch (ServletException e) {
                        se = e;
                    }
                    int status = wrappedResponse.getStatus();
                    if (se == null && status >= 200 && status < 400) break block8;
                    wrappedResponse.reset();
                    NamedDispatcher _super = (NamedDispatcher)ServletServiceContext.this.getNamedDispatcher(ServletServiceContext.SUPER);
                    if (_super != null) {
                        _super.forward(request, (ServletResponse)wrappedResponse);
                        break block8;
                    }
                    throw se;
                }
                finally {
                    CallStackHelper.leaveServlet();
                }
            }
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class NamedDispatcher
    implements RequestDispatcher {
        private String servletServiceName;
        private boolean superCall;
        private ServletContext context;

        public NamedDispatcher(String servletServiceName) {
            this.servletServiceName = servletServiceName;
            this.superCall = ServletServiceContext.SUPER.equals(this.servletServiceName);
            this.context = ServletServiceContext.this.getNamedContext(this.servletServiceName);
        }

        protected boolean exists() {
            return this.context != null;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            RequestDispatcher dispatcher;
            if (ServletServiceContext.this.logger.isInfoEnabled()) {
                ServletServiceContext.this.logger.info((Object)("Enter processing in servlet service " + this.servletServiceName));
            }
            if ((dispatcher = this.context.getRequestDispatcher(((HttpServletRequest)request).getPathInfo())) == null || !(dispatcher instanceof PathDispatcher)) {
                throw new IllegalStateException();
            }
            ((PathDispatcher)dispatcher).forward(request, response, this.superCall);
            if (ServletServiceContext.this.logger.isInfoEnabled()) {
                ServletServiceContext.this.logger.info((Object)("Leaving processing in servlet service " + this.servletServiceName));
            }
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            throw new UnsupportedOperationException();
        }
    }
}

