/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.cocoon.servletservice.util.NullServletInputStream;
import org.apache.cocoon.servletservice.util.RequestParameters;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class BlockCallHttpServletRequest
implements HttpServletRequest {
    private static final String PROTOCOL = "HTTP/1.1";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    private HttpServletRequest parent;
    private final URI uri;
    private String method;
    private final Map headers;
    private final RequestParameters parameters;
    private String encoding;
    private int contentLength;
    private ServletInputStream content;
    private final Map attributes;

    public BlockCallHttpServletRequest(URI uri, HttpServletRequest parent) {
        this.parent = parent;
        this.uri = uri;
        this.headers = new HashMap();
        this.parameters = new RequestParameters(this.uri.getQuery());
        this.method = "GET";
        this.contentLength = -1;
        this.content = NullServletInputStream.INSTANCE;
        this.attributes = new HashMap();
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getServerName() {
        return "";
    }

    public int getServerPort() {
        return 80;
    }

    public String getContextPath() {
        return this.parent.getContextPath();
    }

    public String getServletPath() {
        return "";
    }

    public String getPathInfo() {
        return this.uri.getPath();
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.uri.getQuery();
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + this.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getScheme()).append(':').append(this.getRequestURI());
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Enumeration getHeaders(String name) {
        return new IteratorEnumeration(this.headers.values().iterator());
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        try {
            return this.dateFormat.parse(header).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, this.dateFormat.format(new Date(date)));
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public Enumeration getHeaderNames() {
        return new IteratorEnumeration(this.headers.keySet().iterator());
    }

    public String getParameter(String name) {
        return this.parameters.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.parameters.getParameterValues(name);
    }

    public Enumeration getParameterNames() {
        return this.parameters.getParameterNames();
    }

    public Map getParameterMap() {
        return this.parameters.getParameterMap();
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.content;
    }

    public void setInputStream(final InputStream inputStream) {
        try {
            this.contentLength = inputStream.available();
        }
        catch (IOException e) {
            this.contentLength = -1;
        }
        this.content = new ServletInputStream(){

            public int read() throws IOException {
                return inputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        String encoding = this.getCharacterEncoding();
        InputStreamReader reader = encoding == null ? new InputStreamReader((InputStream)this.getInputStream()) : new InputStreamReader((InputStream)this.getInputStream(), encoding);
        return new BufferedReader(reader);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getLocales() {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteUser() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (create) {
            return new HttpSession(){

                public Object getAttribute(String name) {
                    return null;
                }

                public Enumeration getAttributeNames() {
                    return null;
                }

                public long getCreationTime() {
                    return 0L;
                }

                public String getId() {
                    return null;
                }

                public long getLastAccessedTime() {
                    return 0L;
                }

                public int getMaxInactiveInterval() {
                    return 0;
                }

                public ServletContext getServletContext() {
                    return null;
                }

                public HttpSessionContext getSessionContext() {
                    return null;
                }

                public Object getValue(String name) {
                    return null;
                }

                public String[] getValueNames() {
                    return null;
                }

                public void invalidate() {
                }

                public boolean isNew() {
                    return false;
                }

                public void putValue(String name, Object value) {
                }

                public void removeAttribute(String name) {
                }

                public void removeValue(String name) {
                }

                public void setAttribute(String name, Object value) {
                }

                public void setMaxInactiveInterval(int interval) {
                }
            };
        }
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public int getRemotePort() {
        return 0;
    }
}

