/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.servletservice.Absolutizable;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.HttpServletResponseBufferingWrapper;
import org.apache.cocoon.servletservice.util.ServletContextWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletServiceContext
extends ServletContextWrapper
implements Absolutizable {
    public static final String SUPER = "super";
    private final Log logger = LogFactory.getLog(ServletServiceContext.class);
    private Map attributes = new Hashtable();
    private Servlet servlet;
    private String mountPath;
    private String contextPath;
    private URL contextPathURL;
    private Map properties;
    private Map connections;
    private Map connectionServiceNames;
    private String serviceName;

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        return value != null ? value : super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttributes(Map map) {
        if (map != null) {
            this.attributes = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException("The path must begin with a '/' and is interpreted as relative to the current context root.");
        }
        ServletServiceContext servletServiceContext = this;
        synchronized (servletServiceContext) {
            if (this.contextPathURL == null) {
                this.contextPathURL = new URL(this.contextPath);
            }
        }
        return new URL(this.contextPathURL, path.substring(1));
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getInitParameter(String name) {
        ServletContext superContext;
        if (this.properties == null) {
            return null;
        }
        String value = (String)this.properties.get(name);
        if (value == null && (superContext = this.getNamedContext(SUPER)) != null) {
            value = superContext.getInitParameter(name);
        }
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    public Enumeration getInitParameterNames() {
        Vector<Object> names = new Vector<Object>();
        Enumeration enumeration = super.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            names.add(enumeration.nextElement());
        }
        ServletContext superContext = this.getNamedContext(SUPER);
        if (superContext != null) {
            enumeration = superContext.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                names.add(enumeration.nextElement());
            }
        }
        if (this.properties != null) {
            names.addAll(this.properties.keySet());
        }
        return names.elements();
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (IOException e) {
            this.logger.error((Object)("Can't open stream on " + path), (Throwable)e);
            return null;
        }
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    private Collection getDirectoryList(File file, String pathPrefix) {
        ArrayList<String> filenames = new ArrayList<String>();
        if (!file.isDirectory()) {
            filenames.add("/" + file.toString().substring(pathPrefix.length() - 1));
            return filenames;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File subfile = files[i];
            filenames.addAll(this.getDirectoryList(subfile, pathPrefix));
        }
        return filenames;
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            return Collections.EMPTY_SET;
        }
        String pathPrefix = this.contextPath.startsWith("file:") ? this.contextPath.substring("file:".length()) : this.contextPath;
        path = pathPrefix + path;
        File file = new File(path);
        if (!file.exists()) {
            return Collections.EMPTY_SET;
        }
        HashSet set = new HashSet();
        set.addAll(this.getDirectoryList(file, pathPrefix));
        return set;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        PathDispatcher dispatcher = new PathDispatcher(path);
        return dispatcher.exists() ? dispatcher : null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        NamedDispatcher dispatcher = new NamedDispatcher(name);
        return dispatcher.exists() ? dispatcher : null;
    }

    public String getServerInfo() {
        return null;
    }

    public String getServletContextName() {
        return null;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public URI absolutizeURI(URI uri) throws URISyntaxException {
        ServletServiceContext servletServiceContext;
        String servletServiceName = uri.getScheme();
        if (servletServiceName == null) {
            servletServiceContext = this;
        } else {
            servletServiceContext = (ServletServiceContext)this.getNamedContext(servletServiceName);
            if (servletServiceContext == null) {
                throw new URISyntaxException(uri.toString(), "Unknown servlet service name");
            }
        }
        String mountPath = servletServiceContext.getMountPath();
        if (mountPath == null) {
            throw new URISyntaxException(uri.toString(), "No mount point for this URI");
        }
        if (mountPath.endsWith("/")) {
            mountPath = mountPath.substring(0, mountPath.length() - 1);
        }
        String absoluteURI = mountPath + uri.getSchemeSpecificPart();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Resolving " + uri.toString() + " to " + absoluteURI));
        }
        return new URI(absoluteURI);
    }

    public String getServiceName(String connectionName) {
        return (String)this.connectionServiceNames.get(connectionName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServletContext getNamedContext(String name) {
        Servlet _super;
        if (this.connections == null) {
            return null;
        }
        Servlet servlet = (Servlet)this.connections.get(name);
        if (servlet == null && !name.equals(SUPER) && (_super = (Servlet)this.connections.get(SUPER)) != null) {
            ServletContext c = _super.getServletConfig().getServletContext();
            if (c instanceof ServletServiceContext) {
                return ((ServletServiceContext)c).getNamedContext(name);
            }
            return null;
        }
        return servlet != null ? servlet.getServletConfig().getServletContext() : null;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("Context path must not be null.");
        }
        this.contextPath = contextPath.endsWith("/") ? contextPath : contextPath + "/";
    }

    public void setInitParams(Map properties) {
        this.properties = properties;
    }

    public void setConnections(Map connections) {
        this.connections = connections;
    }

    public void setConnectionServiceNames(Map connectionServletServiceNames) {
        this.connectionServiceNames = connectionServletServiceNames;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    private class PathDispatcher
    implements RequestDispatcher {
        private PathDispatcher(String path) {
        }

        private boolean exists() {
            return ServletServiceContext.this.servlet != null;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.forward(request, response, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forward(ServletRequest request, ServletResponse response, boolean superCall) throws ServletException, IOException {
            try {
                HttpServletResponseBufferingWrapper wrappedResponse = new HttpServletResponseBufferingWrapper((HttpServletResponse)response);
                wrappedResponse.setStatus(200);
                if (!superCall) {
                    CallStackHelper.enterServlet(ServletServiceContext.this, (HttpServletRequest)request, (HttpServletResponse)wrappedResponse);
                } else {
                    CallStackHelper.enterSuperServlet(ServletServiceContext.this, (HttpServletRequest)request, (HttpServletResponse)wrappedResponse);
                }
                ServletServiceContext.this.servlet.service(request, (ServletResponse)wrappedResponse);
                int status = wrappedResponse.getStatusCode();
                NamedDispatcher _super = (NamedDispatcher)ServletServiceContext.this.getNamedDispatcher(ServletServiceContext.SUPER);
                if (status == 404 && _super != null) {
                    wrappedResponse.resetBufferedResponse();
                    _super.forward(request, response);
                } else {
                    wrappedResponse.flushBufferedResponse();
                }
            }
            finally {
                CallStackHelper.leaveServlet();
            }
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class NamedDispatcher
    implements RequestDispatcher {
        private final String servletServiceName;
        private final boolean superCall;
        private final ServletContext context;

        public NamedDispatcher(String servletServiceName) {
            this.servletServiceName = servletServiceName;
            this.superCall = ServletServiceContext.SUPER.equals(this.servletServiceName);
            this.context = ServletServiceContext.this.getNamedContext(this.servletServiceName);
        }

        protected boolean exists() {
            return this.context != null;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            RequestDispatcher dispatcher;
            if (ServletServiceContext.this.logger.isInfoEnabled()) {
                ServletServiceContext.this.logger.info((Object)("Enter processing in servlet service " + this.servletServiceName));
            }
            if ((dispatcher = this.context.getRequestDispatcher(((HttpServletRequest)request).getPathInfo())) == null || !(dispatcher instanceof PathDispatcher)) {
                throw new IllegalStateException();
            }
            ((PathDispatcher)dispatcher).forward(request, response, this.superCall);
            if (ServletServiceContext.this.logger.isInfoEnabled()) {
                ServletServiceContext.this.logger.info((Object)("Leaving processing in servlet service " + this.servletServiceName));
            }
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            throw new UnsupportedOperationException();
        }
    }
}

