/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.callstack.environment;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.callstack.CallFrame;
import org.apache.cocoon.callstack.CallStack;

public abstract class CallFrameHelper {
    public static final String REQUEST_OBJECT = "request";
    public static final String RESPONSE_OBJECT = "response";
    public static final String CONTEXT_OBJECT = "context";

    public static final void setEnvironment(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        CallFrame frame = CallStack.getCurrentFrame();
        frame.setAttribute(REQUEST_OBJECT, request);
        frame.setAttribute(RESPONSE_OBJECT, response);
        frame.setAttribute(CONTEXT_OBJECT, context);
    }

    public static final HttpServletRequest getRequest() {
        CallFrame currentCallFrame = CallStack.getCurrentFrame();
        if (currentCallFrame == null) {
            return null;
        }
        return (HttpServletRequest)currentCallFrame.getAttribute(REQUEST_OBJECT);
    }

    public static final void setRequest(HttpServletRequest request) {
        CallStack.getCurrentFrame().setAttribute(REQUEST_OBJECT, request);
    }

    public static final HttpServletResponse getResponse() {
        CallFrame currentCallFrame = CallStack.getCurrentFrame();
        if (currentCallFrame == null) {
            return null;
        }
        return (HttpServletResponse)currentCallFrame.getAttribute(RESPONSE_OBJECT);
    }

    public static final void setResponse(HttpServletResponse response) {
        CallStack.getCurrentFrame().setAttribute(RESPONSE_OBJECT, response);
    }

    public static final ServletContext getContext() {
        CallFrame currentCallFrame = CallStack.getCurrentFrame();
        if (currentCallFrame == null) {
            return null;
        }
        return (ServletContext)currentCallFrame.getAttribute(CONTEXT_OBJECT);
    }

    public static final void setContext(ServletContext context) {
        CallStack.getCurrentFrame().setAttribute(CONTEXT_OBJECT, context);
    }
}

