/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.url;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.cocoon.servletservice.AbsoluteServletConnection;
import org.apache.cocoon.servletservice.Absolutizable;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.NoCallingServletServiceRequestAvailableException;
import org.apache.cocoon.servletservice.ServletConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletURLConnection
extends HttpURLConnection {
    private final ServletConnection servletConnection;
    private final URL url;
    private final Log logger = LogFactory.getLog(this.getClass());

    protected ServletURLConnection(URL url) throws URISyntaxException {
        super(url);
        String servletName;
        this.url = url;
        URI locationUri = null;
        String query = url.getQuery();
        locationUri = query != null ? new URI(url.getPath() + "?" + url.getQuery()) : new URI(url.getPath());
        String servletReference = locationUri.getScheme();
        Absolutizable absolutizable = (Absolutizable)CallStackHelper.getCurrentServletContext();
        if (servletReference == null) {
            if (absolutizable == null) {
                throw new NoCallingServletServiceRequestAvailableException("A self-reference requires an active servlet request.");
            }
            servletName = absolutizable.getServiceName();
        } else if (servletReference.endsWith(AbsoluteServletConnection.ABSOLUTE_SERVLET_SOURCE_POSTFIX)) {
            servletName = servletReference.substring(0, servletReference.length() - 1);
        } else {
            if (absolutizable == null) {
                throw new NoCallingServletServiceRequestAvailableException("A relative servlet call requires an active servlet request.");
            }
            servletName = absolutizable.getServiceName(servletReference);
        }
        this.servletConnection = new AbsoluteServletConnection(servletName, locationUri.getRawPath(), locationUri.getRawQuery());
        this.servletConnection.setIfModifiedSince(0L);
    }

    @Override
    public void connect() throws IOException {
        try {
            if (this.connected) {
                return;
            }
            this.servletConnection.connect();
            this.connected = true;
        }
        catch (ServletException e) {
            IOException ioException = new IOException("Can't connect to servlet URL " + this.url + ".");
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Override
    public InputStream getErrorStream() {
        if (!this.connected) {
            return null;
        }
        try {
            return this.servletConnection.getInputStream();
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            this.connect();
            return this.servletConnection.getInputStream();
        }
        catch (ServletException e) {
            IOException ioException = new IOException("Can't read from servlet URL " + this.url + ".");
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Override
    public long getLastModified() {
        try {
            this.connect();
        }
        catch (IOException e) {
            return 0L;
        }
        return this.servletConnection.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.servletConnection.getOutputStream();
    }

    @Override
    public String getContentType() {
        return this.servletConnection.getContentType();
    }

    @Override
    public int getResponseCode() {
        try {
            this.connect();
            return this.servletConnection.getResponseCode();
        }
        catch (IOException e) {
            return 500;
        }
    }

    @Override
    public void disconnect() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean usingProxy() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HashMap result = new HashMap();
        Map<String, String> headers = this.servletConnection.getHeaders();
        for (Map.Entry<String, String> eachHeader : headers.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(eachHeader.getValue());
            result.put(eachHeader.getKey(), Collections.unmodifiableList(values));
        }
        return Collections.unmodifiableMap(result);
    }
}

