/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.cocoon.callstack.CallFrame;
import org.apache.cocoon.callstack.CallStack;
import org.apache.cocoon.servletservice.ServletServiceContext;
import org.apache.cocoon.servletservice.util.NullServletInputStream;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class ServletServiceRequest
implements HttpServletRequest {
    private static final String PROTOCOL = "HTTP/1.1";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    private HttpServletRequest parentRequest;
    private final URI uri;
    private String method;
    private final Headers headers;
    private String encoding;
    private int contentLength;
    private ServletInputStream content;
    private final Attributes attributes;
    private Parameters parameters;
    private ServletServiceContext context;

    public ServletServiceRequest(URI uri, HttpServletRequest parentRequest) {
        this.parentRequest = parentRequest;
        this.uri = uri;
        this.headers = new Headers();
        this.method = "GET";
        this.contentLength = -1;
        this.content = NullServletInputStream.INSTANCE;
        this.attributes = new Attributes();
        this.parameters = new Parameters();
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getServerName() {
        return this.parentRequest.getServerName();
    }

    public int getServerPort() {
        return this.parentRequest.getServerPort();
    }

    public String getContextPath() {
        return this.parentRequest.getContextPath();
    }

    public String getServletPath() {
        return "";
    }

    public String getPathInfo() {
        return this.uri.getPath();
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.uri.getQuery();
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + this.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getScheme()).append(':').append(this.getRequestURI());
    }

    public String getHeader(String name) {
        return (String)this.headers.getValue(name);
    }

    public Enumeration getHeaders(String name) {
        return this.headers.getNames();
    }

    public void setHeader(String name, String value) {
        this.headers.setValue(name, value);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        try {
            return this.dateFormat.parse(header).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, this.dateFormat.format(new Date(date)));
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public Enumeration getHeaderNames() {
        return this.headers.getNames();
    }

    public String getParameter(String name) {
        return (String)this.parameters.getValue(name);
    }

    public String[] getParameterValues(String name) {
        return this.parameters.getValues(name);
    }

    public Enumeration getParameterNames() {
        return this.parameters.getNames();
    }

    public Map getParameterMap() {
        return this.parameters.getValues();
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.content;
    }

    public void setInputStream(final InputStream inputStream) {
        try {
            this.contentLength = inputStream.available();
        }
        catch (IOException e) {
            this.contentLength = -1;
        }
        this.content = new ServletInputStream(){

            public int read() throws IOException {
                return inputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        String encoding = this.getCharacterEncoding();
        InputStreamReader reader = encoding == null ? new InputStreamReader((InputStream)this.getInputStream()) : new InputStreamReader((InputStream)this.getInputStream(), encoding);
        return new BufferedReader(reader);
    }

    public Object getAttribute(String name) {
        return this.attributes.getValue(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.getNames();
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.setValue(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.parentRequest.getCookies();
    }

    public Locale getLocale() {
        return this.parentRequest.getLocale();
    }

    public Enumeration getLocales() {
        return this.parentRequest.getLocales();
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return this.parentRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.parentRequest.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.parentRequest.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        return this.parentRequest.getRequestedSessionId();
    }

    public HttpSession getSession() {
        Session session = (Session)this.getSession(true);
        session.setRequest(this);
        return session;
    }

    public HttpSession getSession(boolean create) {
        HttpServletRequest request = this.parentRequest;
        while (request != null && request instanceof ServletServiceRequest) {
            request = ((ServletServiceRequest)request).parentRequest;
        }
        HttpSession outestSession = request.getSession();
        Session session = null;
        session = this != request ? (Session)outestSession.getAttribute(HttpSession.class + "_" + this.context.getMountPath()) : (Session)outestSession;
        if (session == null && create) {
            session = new Session(this.context);
            outestSession.setAttribute(HttpSession.class + "_" + this.context.getMountPath(), (Object)session);
        }
        if (session != null) {
            session.setRequest(this);
        }
        return session;
    }

    public void setContext(ServletContext context) {
        this.context = (ServletServiceContext)context;
    }

    public Principal getUserPrincipal() {
        return this.parentRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.parentRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.parentRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.parentRequest.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.parentRequest.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this.parentRequest.isUserInRole(role);
    }

    public String getLocalAddr() {
        return this.parentRequest.getLocalAddr();
    }

    public String getLocalName() {
        return this.parentRequest.getLocalName();
    }

    public int getLocalPort() {
        return this.parentRequest.getLocalPort();
    }

    public int getRemotePort() {
        return this.parentRequest.getRemotePort();
    }

    private static class Session
    extends Values
    implements HttpSession {
        private ServletServiceContext context;
        private transient ServletServiceRequest request;

        public Session(ServletServiceContext context) {
            this.context = context;
        }

        protected Object getValueOfCaller(String name) {
            return this.getRequest().parentRequest.getSession().getAttribute(name);
        }

        protected Enumeration namesOf(HttpServletRequest request) {
            return this.getRequest().parentRequest.getSession().getAttributeNames();
        }

        protected ServletServiceRequest getRequest() {
            return this.request;
        }

        private void setRequest(ServletServiceRequest request) {
            this.request = request;
        }

        public Object getAttribute(String name) {
            if (this.values.containsKey(name)) {
                return this.values.get(name);
            }
            return this.getValueOfCaller(name);
        }

        public Enumeration getAttributeNames() {
            return this.getNames();
        }

        public long getCreationTime() {
            return this.getRequest().parentRequest.getSession().getCreationTime();
        }

        public String getId() {
            return this.getRequest().parentRequest.getSession().getId();
        }

        public long getLastAccessedTime() {
            return this.getRequest().parentRequest.getSession().getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return this.getRequest().parentRequest.getSession().getMaxInactiveInterval();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public HttpSessionContext getSessionContext() {
            throw new UnsupportedOperationException();
        }

        public String[] getValueNames() {
            throw new UnsupportedOperationException();
        }

        public void invalidate() {
            this.getRequest().parentRequest.getSession().invalidate();
        }

        public boolean isNew() {
            return this.getRequest().parentRequest.getSession().isNew();
        }

        public void putValue(String name, Object value) {
            this.setValue(name, value);
        }

        public void removeAttribute(String name) {
            this.removeValue(name);
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.setValue(name, value);
        }

        public void setMaxInactiveInterval(int interval) {
            this.getRequest().parentRequest.getSession().setMaxInactiveInterval(interval);
        }

        protected void setValue(String name, Object value) {
            this.values.put(name, value);
        }

        public Object getValue(String name) {
            return this.values.get(name);
        }
    }

    private class Attributes
    extends Values {
        private Attributes() {
        }

        public Object getValue(String name) {
            if (this.values.containsKey(name)) {
                return this.values.get(name);
            }
            return this.getValueOfCaller(name);
        }

        public Object getValueOfCaller(String name) {
            return this.getRequest().parentRequest.getAttribute(name);
        }

        protected void setValue(String name, Object value) {
            this.values.put(name, value);
        }

        public void remove(String name) {
            if (this.values.containsKey(name)) {
                this.values.remove(name);
            } else {
                this.getRequest().parentRequest.removeAttribute(name);
            }
        }

        protected ServletServiceRequest getRequest() {
            return ServletServiceRequest.this;
        }

        protected Enumeration namesOf(HttpServletRequest request) {
            return request.getAttributeNames();
        }
    }

    private class Headers
    extends Values {
        private Headers() {
        }

        public Object getValueOfCaller(String name) {
            return this.getRequest().parentRequest.getHeader(name);
        }

        public Enumeration getValues(String name) {
            List list = (List)this.values.get(name);
            if (list == null) {
                return new Enumeration(){

                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        throw new NoSuchElementException();
                    }
                };
            }
            return new IteratorEnumeration(list.iterator());
        }

        protected ServletServiceRequest getRequest() {
            return ServletServiceRequest.this;
        }

        protected Enumeration namesOf(HttpServletRequest request) {
            return request.getHeaderNames();
        }
    }

    private class Parameters
    extends Values {
        public Parameters() {
            if (this.getRequest().uri.getQuery() != null) {
                StringTokenizer st = new StringTokenizer(this.getRequest().uri.getQuery(), "&");
                while (st.hasMoreTokens()) {
                    String pair = st.nextToken();
                    int pos = pair.indexOf(61);
                    if (pos == -1) continue;
                    this.setValue(this.parseName(pair.substring(0, pos)), this.parseName(pair.substring(pos + 1, pair.length())));
                }
            }
        }

        private String parseName(String s) {
            StringBuffer sb = new StringBuffer();
            block7: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '+': {
                        sb.append(' ');
                        continue block7;
                    }
                    case '%': {
                        try {
                            if (s.charAt(i + 1) == 'u') {
                                sb.append((char)Integer.parseInt(s.substring(i + 2, i + 6), 16));
                                i += 5;
                                continue block7;
                            }
                            sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block7;
                        }
                        catch (NumberFormatException e) {
                            IllegalArgumentException iae = new IllegalArgumentException();
                            iae.initCause(e);
                            throw iae;
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            String rest = s.substring(i);
                            sb.append(rest);
                            if (rest.length() != 2) continue block7;
                            ++i;
                            continue block7;
                        }
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        public Map getValues() {
            HashMap result = new HashMap();
            for (int i = 0; i < CallStack.size(); ++i) {
                CallFrame frame = CallStack.frameAt(i);
                HttpServletRequest request = (HttpServletRequest)frame.getAttribute("request");
                if (request instanceof ServletServiceRequest) {
                    result.putAll(this.values);
                } else {
                    result.putAll(request.getParameterMap());
                }
                if (request.equals(this.getRequest())) break;
            }
            return result;
        }

        public String[] getValues(String name) {
            List list = (List)this.values.get(name);
            if (list == null) {
                return null;
            }
            String[] result = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = (String)list.get(i);
            }
            return result;
        }

        protected ServletServiceRequest getRequest() {
            return ServletServiceRequest.this;
        }

        protected Object getValueOfCaller(String name) {
            return this.getRequest().parentRequest.getParameter(name);
        }

        protected Enumeration namesOf(HttpServletRequest request) {
            return request.getParameterNames();
        }
    }

    private static abstract class Values
    implements Serializable {
        Map values = new HashMap();

        protected void setValue(String name, Object value) {
            List<Object> list;
            if (this.values.containsKey(name)) {
                list = (List)this.values.get(name);
            } else {
                list = new ArrayList();
                this.values.put(name, list);
            }
            list.add(value);
        }

        public Object getValue(String name) {
            if (this.values.containsKey(name)) {
                return ((List)this.values.get(name)).get(0);
            }
            return this.getValueOfCaller(name);
        }

        protected abstract Object getValueOfCaller(String var1);

        protected abstract Enumeration namesOf(HttpServletRequest var1);

        public Enumeration getNames() {
            HashSet<Object> names = new HashSet<Object>();
            for (int i = 0; i < CallStack.size(); ++i) {
                CallFrame frame = CallStack.frameAt(i);
                HttpServletRequest request = (HttpServletRequest)frame.getAttribute("request");
                if (request instanceof ServletServiceRequest) {
                    names.addAll(this.values.keySet());
                } else {
                    Enumeration enumeration = this.namesOf(request);
                    while (enumeration.hasMoreElements()) {
                        names.add(enumeration.nextElement());
                    }
                }
                if (request.equals(this.getRequest())) break;
            }
            return new EnumerationFromIterator(names.iterator());
        }

        protected abstract ServletServiceRequest getRequest();

        final class EnumerationFromIterator
        implements Enumeration {
            private Iterator iterator;

            EnumerationFromIterator(Iterator iter) {
                this.iterator = iter;
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }
}

