/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.callstack.environment.CallFrameHelper;
import org.apache.cocoon.servletservice.AbstractServletConnection;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.util.ServletServiceRequest;
import org.apache.cocoon.servletservice.util.ServletServiceResponse;

public final class RelativeServletConnection
extends AbstractServletConnection {
    private String connectionName;

    public RelativeServletConnection(String connectionName, String path, String queryString) {
        URI reqUri;
        if (path == null) {
            throw new IllegalArgumentException("Path musn't be null.");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to start with a slash '/' because it is always absolute within this servlet context.");
        }
        this.connectionName = connectionName;
        try {
            this.uri = new URI(connectionName != null ? connectionName : "local", null, path, queryString, null);
            this.uri = new URI("servlet", this.uri.toASCIIString(), null);
            reqUri = new URI("servlet", null, path, queryString, null);
        }
        catch (URISyntaxException e) {
            String message = "Invalid relative servlet service URI created.";
            this.logger.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        this.context = "super".equals(this.connectionName) ? CallStackHelper.getCurrentServletContext() : CallStackHelper.getBaseServletContext();
        if (this.context == null) {
            throw new AbstractServletConnection.NoServletContextAvailableException("A servlet connection can only be used with an available servlet context. [" + this.uri + "]");
        }
        this.request = new ServletServiceRequest(reqUri, CallFrameHelper.getRequest());
        this.response = new ServletServiceResponse();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving relative servlet URI " + this.uri.toASCIIString()));
        }
    }

    protected void performConnect() throws ServletException, IOException {
        RequestDispatcher dispatcher = this.connectionName == null ? this.context.getRequestDispatcher(null) : this.context.getNamedDispatcher(this.connectionName);
        if (dispatcher == null) {
            throw new ServletException("No dispatcher for connection" + this.connectionName);
        }
        dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
    }
}

